function density::can_extract, cnts, offs
  
  for i=0, n_elements(cnts) do begin
    if (*self.lastoffs)[i] gt offs[i] then return, 0
    if (offs[i]+cnts[i]) gt ((*self.lastoffs)[i]+(*self.lastcnts)[i]) then return, 0    
  endfor

  return, 1
end

function density::extract_density, vid, cnts, offs

  if (vid eq self.lastvid) then begin
    ndims = n_elements(offsets)

    if (ndims eq n_elements(*self.lastoffs)) then begin
      if self->can_extract(cnts, offs) then begin
        loffs = *self.lastoffs
        case ndims of 
         1: begin
              data = (*self.lastdata)[offs[0]-loffs[0]:offs[0]-loffs[0]+cnts[0]]
            end
         2: begin
              data = (*self.lastdata)[offs[0]-loffs[0]:offs[0]-loffs[0]+cnts[0],$
                                      offs[1]-loffs[1]:offs[1]-loffs[1]+cnts[1]]
            end
         3: begin
              data = (*self.lastdata)[offs[0]-loffs[0]:offs[0]-loffs[0]+cnts[0],$
                                      offs[1]-loffs[1]:offs[1]-loffs[1]+cnts[1],$
                                      offs[2]-loffs[2]:offs[2]-loffs[2]+cnts[2]]
            end
         4: begin
              data = (*self.lastdata)[offs[0]-loffs[0]:offs[0]-loffs[0]+cnts[0],$
                                      offs[1]-loffs[1]:offs[1]-loffs[1]+cnts[1],$
                                      offs[2]-loffs[2]:offs[2]-loffs[2]+cnts[2],$
                                      offs[3]-loffs[3]:offs[3]-loffs[3]+cnts[3]]
            end
         else:
        endcase
      endif else data = self->compute_density(vid, cnts, offs)
    endif else data = self->compute_density(vid, cnts, offs)

  endif else data = self->compute_density(vid, cnts, offs)

  self.vid = vid
  self.lastoffs = ptr_new( offs )
  self.lastcnts = ptr_new( cnts )

  return, data
end

pro density::cleanup
  if ptr_valid(self.lastdata) then ptr_free, self.lastdata
  if ptr_valid(self.lastcnts) then ptr_free, self.lastcnts
  if ptr_valid(self.lastoffs) then ptr_free, self.lastoffs
end

function density::init
  self.lastvid = -1
  return, 1
end

PRO density__define
   
    struct = { density,            $ ; abstract class 

               lastdata:ptr_new(), $
               lastcnts:ptr_new(), $
               lastoffs:ptr_new(), $
               lastvid:0L $
             }

end
