; method to define action for each coordinate according to plot type
PRO geov_extractor::make_actions, ptype
    @geov_pars

    ; construct actions array for this plot
    (*self.actions)[*] = (*self.icoords)[*]  ; copy values from coordinate selection

    ; set X, Y axis
    CASE ptype OF

      ; 1D

        VARvsLAT: BEGIN
                     ilat = self.ncfiles->get_ilat()
                     (*self.actions)[ilat] = XAXIS
                   END

        VARvsLON: BEGIN
                     ilon = self.ncfiles->get_ilon()
                     (*self.actions)[ilon] = XAXIS
                   END

         LEVvsVAR: BEGIN

                     ilev = self.ncfiles->get_ilev()
                     (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                   END

        VARvsTIM: BEGIN
                     itim = self.ncfiles->get_itim()
                     (*self.actions)[itim] = XAXIS
                   END

        LONaveVARvsLAT: BEGIN
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE

                          ilat = self.ncfiles->get_ilat()
                          (*self.actions)[ilat] = XAXIS
                        END

        LONaveLEVvsVAR: BEGIN
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE
                          ilev = self.ncfiles->get_ilev()
                          (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                        END

        LONaveVARvsTIM: BEGIN
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE
                          itim = self.ncfiles->get_itim()
                          (*self.actions)[itim] = XAXIS
                        END

        LATLONaveLEVvsVAR: BEGIN
                             ilon = self.ncfiles->get_ilon()
                             (*self.actions)[ilon] = AVERAGE
                             ilat = self.ncfiles->get_ilat()
                             (*self.actions)[ilat] = WEIGHTEDAVE
                             ilev = self.ncfiles->get_ilev()
                             (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                           END
        LATaveLEVvsVAR: BEGIN

                             ilat = self.ncfiles->get_ilat()
                             (*self.actions)[ilat] = WEIGHTEDAVE
                             ilev = self.ncfiles->get_ilev()
                             (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                           END

        LATLONaveVARvsTIM: BEGIN
                             ilon = self.ncfiles->get_ilon()
                             (*self.actions)[ilon] = AVERAGE
                             ilat = self.ncfiles->get_ilat()
                             (*self.actions)[ilat] = WEIGHTEDAVE
                             itim = self.ncfiles->get_itim()
                             (*self.actions)[itim] = XAXIS
                           END

        LATaveVARvsTIM: BEGIN
                             ilat = self.ncfiles->get_ilat()
                             (*self.actions)[ilat] = WEIGHTEDAVE
                             itim = self.ncfiles->get_itim()
                             (*self.actions)[itim] = XAXIS
                           END

      ; 2D

        LATLONaveLEVvsTIM: BEGIN
                          itim = self.ncfiles->get_itim()
                          (*self.actions)[itim] = XAXIS
                          ilev = self.ncfiles->get_ilev()
                          (*self.actions)[ilev] = YAXIS
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE
                          ilat = self.ncfiles->get_ilat()
                          (*self.actions)[ilat] = WEIGHTEDAVE

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                        END
        LATaveLEVvsTIM: BEGIN
                          itim = self.ncfiles->get_itim()
                          (*self.actions)[itim] = XAXIS
                          ilev = self.ncfiles->get_ilev()
                          (*self.actions)[ilev] = YAXIS
                          ilat = self.ncfiles->get_ilat()
                          (*self.actions)[ilat] = WEIGHTEDAVE

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                        END
        LATvsLON: BEGIN
                     ilat = self.ncfiles->get_ilat()
                     (*self.actions)[ilat] = YAXIS
                     ilon = self.ncfiles->get_ilon()
                     (*self.actions)[ilon] = XAXIS
                  END

        LATvsLONpress: BEGIN
                     ilat = self.ncfiles->get_ilat()
                     (*self.actions)[ilat] = YAXIS
                     ilon = self.ncfiles->get_ilon()
                     (*self.actions)[ilon] = XAXIS
                     ilev = self.ncfiles->get_ilev()
                     (*self.actions)[ilev] = CONSTPRESS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = CONSTPRESS

                  END

        LEVvsLAT: BEGIN
                     ilat = self.ncfiles->get_ilat()
                     (*self.actions)[ilat] = XAXIS
                     ilev = self.ncfiles->get_ilev()
                     (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                  END

        LEVvsLON: BEGIN
                     ilon = self.ncfiles->get_ilon()
                     (*self.actions)[ilon] = XAXIS
                     ilev = self.ncfiles->get_ilev()
                     (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                  END

        LATvsTIM: BEGIN
                     itim = self.ncfiles->get_itim()
                     (*self.actions)[itim] = XAXIS
                     ilat = self.ncfiles->get_ilat()
                     (*self.actions)[ilat] = YAXIS
                  END

        LONvsTIM: BEGIN
                     itim = self.ncfiles->get_itim()
                     (*self.actions)[itim] = XAXIS
                     ilon = self.ncfiles->get_ilon()
                     (*self.actions)[ilon] = YAXIS
                  END

        LEVvsTIM: BEGIN
                     itim = self.ncfiles->get_itim()
                     (*self.actions)[itim] = XAXIS
                     ilev = self.ncfiles->get_ilev()
                     (*self.actions)[ilev] = YAXIS

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                  END

        LONaveLEVvsLAT: BEGIN
                          ilat = self.ncfiles->get_ilat()
                          (*self.actions)[ilat] = XAXIS
                          ilev = self.ncfiles->get_ilev()
                          (*self.actions)[ilev] = YAXIS
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                        END

        LONaveLATvsTIM: BEGIN
                          itim = self.ncfiles->get_itim()
                          (*self.actions)[itim] = XAXIS
                          ilat = self.ncfiles->get_ilat()
                          (*self.actions)[ilat] = YAXIS
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE
                        END

        LONaveLEVvsTIM: BEGIN
                          itim = self.ncfiles->get_itim()
                          (*self.actions)[itim] = XAXIS
                          ilev = self.ncfiles->get_ilev()
                          (*self.actions)[ilev] = YAXIS
                          ilon = self.ncfiles->get_ilon()
                          (*self.actions)[ilon] = AVERAGE

                     ilevi = self.ncfiles->get_ilevi()
                     if ilevi ge 0 then (*self.actions)[ilevi] = YAXIS

                        END


    ELSE: BEGIN

            ; MAP plot
            pstruct= geov_get_bit_struct(ptype)
            if (pstruct.mapbit gt 0) then begin
                ilat = self.ncfiles->get_ilat()
                (*self.actions)[ilat] = YAXIS
                ilon = self.ncfiles->get_ilon()
                (*self.actions)[ilon] = XAXIS
            endif

          END

    ENDCASE

END
