; driver method called when the current plotter changes
PRO geov_gui::change_focus, plotter

print, '************** change_focus *******************'

    ; save id of previous plotter
    old_iplotter = self.iplotter

    ; set new plotter object
    self->set_plotter, plotter

    ; give focus to plotter window
    plotter->focus

    ; update control panels with selection for this plotter
    self->import_all

    ; if plotter changed, must redraw plot to re-establish coordinate transformation
    ptype = plotter->get_ptype()
    if (self.iplotter ne old_iplotter and ptype ne 0) then plotter->plot

    ; activate controls accordingly
    self->activator

END
