; GEOV_GUI: object representing GUI for user selection
; associated with one geov_ncfile object
; manages one or more PLOTTER objects
; mgs (22 April 2002) : added uvwind switch

PRO geov_gui__define
    @geov_pars

    struct = { geov_gui,                    $ ; class name
               inherits gui,                $ ; superclass
               inherits geov_plotters_user, $ ; superclass

               ; OBJECT REFERENCES
               manager:obj_new(),           $ ; parent geov_manager object
               ncfiles:obj_new(),           $ ; refernce to geov_multifiles obj

               ; VARIABLES
               edges:ptr_new(),             $ ; edges[ipv] --> edges for that vaiable
               ptype:0L,                    $ ; stores last selection from plot buttons
               map:0L,                      $ ; stores last map selection

               totcol_flag:0L,              $ ; flag for tot col dens selection
               numden_flag:0L,              $
               tmass_flag:0L,               $
               summed_flds:ptr_new(),       $
               sum_coefs:'', $
               show_sum_gui:0, $
               dataname:'', $
               
               ; WIDGET IDS
               bar_base:0L,                 $ ; widget id for upper menu bar
               file_menu_wid:0L,            $ ; widget id for file menu
               close_wid:0L,                $ ; widget id for close button
               exit_wid:0L,                 $ ; widget id for exit button
               open_wid:0L,                 $ ; widget id for open file button
               quit_wid:0L,                 $ ; widget id for quit geov button
               display_menu_wid:0L,         $ ; widget id for display menu
               mycolors_wid:0L,             $ ; widget id for contour colors
               idlcolors_wid:0L,            $ ; widget id for IDL color table
               bwrcolors_wid:0L,            $ ; widget id for blue-white-red color table
               drawcolors_wid:0L,           $ ; widget id for drawing colors
               mydrawcolors:ptr_new() ,     $ ; array containing my draw colors
               contour_wid:0L,              $ ; widget id for contour levels button
               contour_opt_wids:lonarr(5),  $ ; widget ids for contour type options
               timeaxis_wids:lonarr(TIMEAXIS_TYPES),  $ ; widget ids for time axis options
               unzoom_wid:0L,               $ ; widget id for unzoom button
               reset_axes_wid:0L,           $ ; widget id for axes-reset button
               animate_wid:0L,              $ ; widget id for animation button
               fanimate_wid:0L,             $ ; widget id for animation-to-file button
               titles_wid:0L,               $ ; widget id to open titles editor gui
               new_window_wids:lonarr(3),   $ ; widget ids to open a new window
               map_menu_wid:0L,             $ ; widget id for map menu
               plot2d_menu_wid:0L,          $ ; widget id for 2D plots menu
               plot1d_menu_wid:0L,          $ ; widget id for 2D plots menu
               pbuttons_wid:ptr_new(),      $ ; array containing widget ids of plot buttons
               pbuttons_mask:ptr_new(),     $ ; array containing bit mask to make button active/inactive
               pbuttons_values:ptr_new(),   $ ; array containing values associated with buttons
               print_menu_wid:0L,           $ ; widget id for print menu
               print_wids:lonarr(5),        $ ; widget ids for print menu
               print_types:strarr(5),       $ ; supported output types: ps, eps, png, jpg

               help_menu_wid:0L,            $ ; help menu
               about_wid:0L,                $ ; widget for the about information

               auto_log_linear_wid:0L,      $ ; widget for aut-log/linear contours option
               set_format_wids:lonarr(n_elements(CONLABS_FORMAT_OPTS)),   $ ;

               bottom_base:0L, $
               xtr_cntrls_button:0L, $
               hide:0L, $
               totsz:0L, $
               xtrsz:0L, $

               pvars_wid:0L,                $ ; widget index of variable to be plotted
               lats_wid:0L,                 $ ; widget id for latitudes list
               lons_wid:0L,                 $ ; widget id for longitude list
               levs_wid:0L,                 $ ; widget id for levels list
               times_wid:0L,                $ ; widget id for levels list
               ptitle_wid:0L,               $ ; widget id for plot type
               auto_contour_wid:0L,         $ ; radio buttons to fix/unfix contour levels
               scaling_wid:0L,              $ ; checkbox to enable/desable VMR scaling
               logp_wid:0L,                 $ ; widget id for log-p switch
               samescale_wid:0L,            $ ; widget id for samescale switch
               uvwind_wid:0L,               $ ; widget ID for wind vector overlay
               nfiles_wid:0L,               $ ; widget id for number of files to use
               operator_wid:0L,             $ ; widget id for operator
               extractor_wid:0L,             $ ; widget id for operator
               astep_wid:0L,                $ ; widget id for animation step text field
               astart_wid:0L    ,           $ ; widget id for animation start text field
               overplot_wid:0L    ,           $ ; widget id for overplot button
               overplot:0B, $ ; overplot flag

               const_press:ptr_new(), $,
               savepath:' '                 $ ; path to which image files are written
    }

END
