; methods to GET geov_gui private fields (from widgets selection)
FUNCTION geov_gui::get_lat
   if (self.lats_wid gt 0) then return, widget_info(self.lats_wid,/list_select) $  ; list selected index or -1
   else return, -2
END

FUNCTION geov_gui::get_lon
    if (self.lons_wid gt 0) then return, widget_info(self.lons_wid,/list_select) $  ; list selected index or -1
    else return, -2
END

FUNCTION geov_gui::get_lev
    if (self.levs_wid gt 0) then return, widget_info(self.levs_wid,/list_select) $  ; list selected index or -1
    else return, -2
END

FUNCTION geov_gui::get_time
    if (self.times_wid gt 0) then return, widget_info(self.times_wid,/list_select) $ ; list selected index or -1
    else return, -2
END

FUNCTION geov_gui::get_scaling
  widget_control, self.scaling_wid, get_value=value
  return, value
END

FUNCTION geov_gui::get_auto_contour
  widget_control, self.auto_contour_wid, get_value=boolean
  return, boolean
END

FUNCTION geov_gui::get_auto_log_linear
  widget_control, self.auto_log_linear_wid, get_value=value
  return, value
END

FUNCTION geov_gui::get_ipvar
  return, widget_info(self.pvars_wid,/list_select)  ; list selected index or -1
END

FUNCTION geov_gui::get_edges, ipvar
  return, (*self.edges)[ipvar]  ; returns pointer
END

FUNCTION geov_gui::get_ncfiles
  return, self.ncfiles
END

FUNCTION geov_gui::get_const_press
  return, self.const_press
END

FUNCTION geov_gui::get_ptype
  return, self.ptype
END

FUNCTION geov_gui::get_summed_flds
  return, self.summed_flds
END

FUNCTION geov_gui::get_sum_coefs
  return, self.sum_coefs
END

FUNCTION geov_gui::get_dataname
  return, self.dataname
END

FUNCTION geov_gui::get_overplot
;print,'geov_gui::get_overplot... 0'
;  widget_control, self.overplot_wid, get_value=pos
;print,'geov_gui::get_overplot... pos = ',pos
;  return, pos
  return, self.overplot
END

FUNCTION geov_gui::get_operator
  return, widget_info(self.operator_wid,/droplist_select)
END

FUNCTION geov_gui::get_extractor_type
  return, widget_info(self.extractor_wid,/droplist_select)
END

function geov_gui::get_show_sum_gui
  return, self.show_sum_gui
end

FUNCTION geov_gui::get_anim_pars
  widget_control, self.astep_wid, get_value=step
  widget_control, self.astart_wid, get_value=start
  return, {step:step, start:start }
END

; overridden method from superclass
; method to return current plotter
; or create new one if current is invalid
FUNCTION geov_gui::get_plotter
  ; return current plotter or first valid one
  plotter = self->geov_plotters_user::get_plotter()
  if (obj_valid(plotter)) then return, plotter
  ; otherwise, create a new one and return it
  plotter = self.manager->create_plotter( self, $
            (self.manager->get_preferences())->get_window_size() )
  return, plotter
END

FUNCTION geov_gui::get_number_of_plotters
  number=0

  for i=0, n_elements(self.plotters)-1 do begin
    if obj_valid(self.plotters[i]) then number=number+1
  endfor

  return, number
END

function geov_gui::get_extractor
  return, self.extractors[self.igui]
end

function geov_gui::get_totcol_flag
  return, self.totcol_flag 
END

function geov_gui::get_tmass_flag
  return, self.tmass_flag 
END

function geov_gui::get_numden_flag, flag
  return, self.numden_flag 
end

function geov_gui::get_levels_button_value
  if (self.logp_wid gt 0) then $
    widget_control, self.logp_wid, get_value = logpval $
  else $
    return, -1
  return, logpval
end

PRO geov_gui::get
END
