
PRO dump_data, filename, data, xs=xs, ys=ys

  fid = ncdf_create( filename, /clobber )
  ncdf_control, fid, /fill

  xdid = -1
  ydid = -1

  ; initialize the netCDF file

  if( n_elements(xs) gt 0 and n_elements(ys) gt 0 ) then begin
    ; dump xs and ys
    xdid = ncdf_dimdef(fid, 'x', n_elements( xs ))
    ydid = ncdf_dimdef(fid, 'y', n_elements( ys ))
    xvid = ncdf_vardef(fid, 'x', [xdid])
    yvid = ncdf_vardef(fid, 'y', [ydid])
    dvid = ncdf_vardef(fid, 'data',[xdid,ydid], /float)
  endif else if( n_elements(xs) gt 0 ) then begin
    ; dump xs
    xdid = ncdf_dimdef(fid, 'x', n_elements( xs ))
    xvid = ncdf_vardef(fid, 'x', [xdid])
    dvid = ncdf_vardef(fid, 'data',[xdid], /float)
  endif else if ( n_elements(ys) gt 0 ) then begin
    ; dump ys
    ydid = ncdf_dimdef(fid, 'y', n_elements( ys ))
    yvid = ncdf_vardef(fid, 'y', [ydid])
    dvid = ncdf_vardef(fid, 'data',[ydid], /float)
  endif 

  ncdf_control, fid, /endef

  ; put data into netCDF file

  if ( xdid gt -1 and ydid gt -1 ) then begin
    ncdf_varput, fid, xvid, xs
    ncdf_varput, fid, yvid, ys
    ncdf_varput, fid, dvid, data
  endif else if (xdid gt -1) then begin
    ncdf_varput, fid, xvid, xs
    ncdf_varput, fid, dvid, data
  endif else if (ydid gt -1) then begin
    ncdf_varput, fid, yvid, ys
    ncdf_varput, fid, dvid, data
  endif

  ;close the file
   ncdf_close, fid

END

pro test_dump_data

  print,'begin test_dump_data...'
  nx = 10
  ny = 10

  x = findgen(nx)
  y = findgen(nx)

  xydata = findgen(nx,ny)
  xdata = findgen(nx)
  ydata = findgen(ny)

  dump_data, 'xtest.nc', xdata, xs = x
  dump_data, 'ytest.nc', ydata, ys = y
  dump_data, 'xytest.nc', xydata, xs = x, ys = y

  print,'end test_dump_data'
end
