; method to setup plotting parameters (common to 1D and 2D plots)
PRO geov_plotter::setup_params
    @geov_pars
    @nccoord_pars

    ; import variables from current ncfiles
    ncfiles = (self.guis[self.igui])->get_ncfiles()
    dnames = ncfiles->get_dnames()
    cdims  = ncfiles->get_cdims()
    vnames = ncfiles->get_vnames()
    vunits = ncfiles->get_vunits()
    cvars  = ncfiles->get_cvars()
    p2coords = ((self.extractors[self.igui])->get_ncfiles())->get_p2coords()
    vid = (self.extractors[self.igui])->get_vid()
    ipvar = (self.extractors[self.igui])->get_ipvar()
    actions = (self.extractors[self.igui])->get_actions()

    gui = (self.extractors[self.igui])->get_gui()
    totcolflg = gui->get_totcol_flag()


    ; X title
    if (self.icx ge 0) then begin ; coordinate on X axis
       self.xtitle = ncfiles->get_clabel(p2coords[self.icx])
    endif else begin            ; variable on X axis
;       if (self.operator eq OP_NONE or self.operator eq OP_OVERPLOT) then begin
       if (self.operator eq OP_NONE ) then begin
          self.xtitle=string((*vnames)[vid],' (',(*vunits)[vid],')') 
        ;  if (self.operator eq OP_SMOOTH) then self.xtitle='Smoothed ('+strtrim(self.smooth_width,2)+')'+self.xtitle
          vunits_0 = strlowcase( (*vunits)[vid] )
          if (vunits_0 eq 'vmr' or vunits_0 eq 'mmr' OR vunits_0 EQ 'mole/mole') then begin
             unitstr = ' (' + (*vunits)[vid] + ')'
             if (self.scale_factor eq 1E6) then unitstr = ' (ppm)' $
             else if (self.scale_factor eq 1E9) then unitstr = ' (ppb)' $
             else if (self.scale_factor eq 1E12)then unitstr = ' (ppt)'
             if (totcolflg ne 0) then begin
                if ( strcmp(string((*vnames)[vid]), 'O3', 2, /fold_case) or $
                     strcmp(string((*vnames)[vid]), 'OX', 2, /fold_case) ) then unitstr = ' (DU)'
             endif
             self.xtitle=string((*vnames)[vid],  unitstr )
          ENDIF
       endif else self.xtitle = operator_names[self.operator]
    endelse

    ; Y title
    if (self.icy ge 0) then begin ; coordinate on Y axis
       self.ytitle = ncfiles->get_clabel(p2coords[self.icy])
    endif else begin            ; variable on Y axis
;       if (self.operator eq OP_NONE or self.operator eq OP_OVERPLOT or self.operator eq OP_SMOOTH) then begin
       if (self.operator eq OP_NONE or self.operator eq OP_SMOOTH) then begin
          self.ytitle=string((*vnames)[vid],' (',(*vunits)[vid],')') 
          vunits_0 = strlowcase( (*vunits)[vid] )
          if (vunits_0 eq 'vmr' or vunits_0 eq 'mmr' OR vunits_0 EQ 'mole/mole') then begin
             unitstr = ' (' + (*vunits)[vid] + ')'
             if (self.scale_factor eq 1E6) then unitstr = ' (ppm)' $
             else if (self.scale_factor eq 1E9) then unitstr = ' (ppb)' $
             else if (self.scale_factor eq 1E12)then unitstr = ' (ppt)'
             if (totcolflg ne 0) then begin
                if ( strcmp(string((*vnames)[vid]), 'O3', 2, /fold_case) or $
                     strcmp(string((*vnames)[vid]), 'OX', 2, /fold_case) ) then unitstr = ' (DU)'
             endif
             self.ytitle=string((*vnames)[vid],  unitstr )
          ENDIF
       endif else self.ytitle = operator_names[self.operator]
    endelse

    ; global title
    self.title = '!C'
    if (self.igui eq 0) then iother = 1 else iother = 0

    ; loop over extractors in the correct order
    for i=0, 1 do begin
       if (i eq 0) then ix = self.igui else ix = iother
       if ((ix eq self.igui) or (self->is_binary(self.operator) eq 1)) then begin

          ncfiles = (self.extractors[ix])->get_ncfiles()
          ncfilename = ncfiles->get_fname()
          vid = (self.extractors[ix])->get_vid()

          if (self.window_size[0] lt 0.45) then ncfilename = extract_filename(ncfilename)

          dnames = ncfiles->get_dnames()
          cdims  = ncfiles->get_cdims()
          vnames = ncfiles->get_vnames()
          vunits = ncfiles->get_vunits()
          vunits_0 = strlowcase( (self.extractors[self.igui])->get_vunits() )
          unitstr = ' [' + (*vunits)[vid] + ']'

          if (vunits_0 eq 'vmr' or vunits_0 eq 'mmr' OR vunits_0 EQ 'mole/mole') then begin
             if (ix eq iother) then plttr = ((self.extractors[iother])->get_gui())->get_plotter() $
             else plttr = self
             if (plttr.scale_factor eq 1E6) then unitstr = ' [ppm]' $
             else if (plttr.scale_factor eq 1E9) then unitstr = ' [ppb]' $
             else if (plttr.scale_factor eq 1E12)then unitstr = ' [ppt]'
          ENDIF

          cvars  = ncfiles->get_cvars()
          p2coords = ((self.extractors[ix])->get_ncfiles())->get_p2coords()
          ipvar = (self.extractors[ix])->get_ipvar()
          actions = (self.extractors[ix])->get_actions()

          ; overplot variable title
          if (ix eq iother) then self.otitle=string((*vnames)[vid],unitstr)

          self.ncfilename = ncfilename

          if (self.window_size[1] ge 0.35) then self.title = self.title + '!C'

          gui = (self.extractors[ix])->get_gui()


          numdenflg = gui->get_numden_flag()
          totcolflg = gui->get_totcol_flag()
          tmassflg = gui->get_tmass_flag()

          ;if (self.operator eq OP_NUM_DENS) then begin
          if (numdenflg ne 0) then begin
            unitstr = ' Density [cm!S!U-3!N]'
          ;endif else if ((self.operator eq OP_TOTAL_COL) or (self.operator eq OP_COL_ABOVE)) then begin
          endif else if (tmassflg ne 0) then begin
            unitstr = ' Total Mass [Tg]'
          ;endif else if ((self.operator eq OP_TOTAL_COL) or (self.operator eq OP_COL_ABOVE)) then begin
          endif else if (totcolflg ne 0 and (vunits_0 eq 'kg/kg' or vunits_0 eq 'mmr') ) then begin
            unitstr = ' Col Mass Dens [kg m!S!U-2!N]'
          endif else if (totcolflg ne 0) then begin
            ;if (self.operator eq OP_TOTAL_COL) then unitstr = ' Total Col. [cm!S!U-2!N]'
            ;if (self.operator eq OP_COL_ABOVE) then unitstr = ' Col. [cm!S!U-2!N]'

            unitstr = ' Col Dens [cm!S!U-2!N]'

            ; use Dobson Units for OX and O3
            if ( strcmp(string((*vnames)[vid]), 'O3', 2, /fold_case) or $
                 strcmp(string((*vnames)[vid]), 'OX', 2, /fold_case) ) then begin
              unitstr = ' Col Dens [DU]'

;              x = (self.extractors[self.igui])->get_data()
;              x = (self.extractors[i])->get_data()
;              self.data= ptr_new((*x)/2.687e16)
               if (ix eq iother) then self.otitle=string((*vnames)[vid],' (DU)') 

            endif
          endif

          ex_type = gui->get_extractor_type()
          if (ex_type eq EX_SUMMATION) then begin 
            self.title = self.title + gui->get_dataname() + unitstr +'!C'
          endif else begin
            self.title = self.title + string((*vnames)[vid]) + unitstr
          endelse

          pvbits = ncfiles->get_pvbits()
          pvmask = (*pvbits)[ipvar] ; plotting variable coordinates mask
          for ic=n_elements(*actions)-1, 0, -1 do begin
             did = (*cdims)[ic]
             cbit = ncfiles->get_cbit(ic) ; coordinate bit
             if ( (pvmask and cbit) gt 0) then begin ; plotted variable depends on this coordinate
                if ( (*actions)[ic] eq WEIGHTEDAVE) then begin
                   self.title = self.title + ', global average'
                endif else if ( (*actions)[ic] eq AVERAGE) then begin
                   ixx = where((*actions) eq WEIGHTEDAVE,nxx)
                   if (nxx lt 1) then self.title = self.title + ', ' + string((*dnames)[did]) + ' average'
                endif else if  ((*actions)[ic] eq CONSTPRESS) then begin
                   self.title = self.title + ', ' + string(*((self.guis[self.igui])->get_const_press()),format='(F10.4)')  + ' mb const press'
                endif else if  ((*actions)[ic] ge 0) then begin
                 ;  if  not ( ncfiles->var_depends_on_ilevi( vid) ) then begin

                   if ( ic eq ncfiles->get_ilev() and ncfiles->var_depends_on_ilevi( vid) ) then begin
                     
                     values = ncfiles->get_coord(ncfiles->get_ilevi())
                     value = (*values)[(*actions)[ncfiles->get_ilevi()]]
                 endif else begin
                
                     values = ncfiles->get_coord(ic)
                     value = (*values)[(*actions)[ic]]
                 endelse

                                ; TIME special case
                   if (ic eq ncfiles->get_itim()) then BEGIN

                      value = ncfiles->get_timestamp(value)

                      self.title = self.title + ', ' + string(value)  ;; +' UT'
                   ENDIF ELSE BEGIN
;; *** ATTENTION: deleted clause for  self.levs2_flag eq 1 !!!
                      if ( (ic eq ncfiles->get_ilev() or ic eq ncfiles->get_ilevi() ) and $ ; LEVELS special case
                          ptr_valid(ncfiles->get_levs2())) then begin
;; mgs 06/21/2002: display either pressure or altitude in title
;; depending on levs2_flag (Log-P button)

                         IF self.levs2_flag THEN BEGIN
                            if ( ncfiles->var_depends_on_ilevi( vid) ) then $
                              value = (*(ncfiles->get_interface_levs2()))[(*actions)[ncfiles->get_ilevi()]] $
                            else $
                              value = (*(ncfiles->get_levs2()))[(*actions)[ic]]
                            if (self.extractor_type eq EX_TOTAL_COL or self.extractor_type eq EX_TROP_COL or self.extractor_type eq EX_ABOVETROP_COL) then levstr = '' $
                            else if (self.extractor_type eq EX_COL_ABOVE) then levstr = ', '  + string(value) + ' km' $
                            else levstr = ', ca. ' + string(value) + ' km'
                         ENDIF ELSE BEGIN
                            if ( ncfiles->var_depends_on_ilevi( vid) ) then $
                              value = (*(ncfiles->get_interface_levs()))[(*actions)[ncfiles->get_ilevi()]] $
                            else $
                              value = (*(ncfiles->get_levs()))[(*actions)[ic]] 
                            
                            if (self.extractor_type eq EX_TOTAL_COL or self.extractor_type eq EX_TROP_COL or self.extractor_type eq EX_ABOVETROP_COL) then levstr = '' $
                            else if (self.extractor_type eq EX_COL_ABOVE) then levstr = ', '  + string(value) + ' hPa' $
                            else levstr = ', ca. ' + string(value) + ' hPa'
                         ENDELSE
                         self.title = self.title + levstr

                      ENDIF ELSE BEGIN
                         self.title = self.title + ', ' + string((*dnames)[did]) + ' ' + string(value)
                      ENDELSE
                   ENDELSE
                ENDIF
             ENDIF
          ENDFOR
          if (tmassflg ne 0) then self.title = string((*vnames)[vid]) + unitstr
          self.title = self.title+'!C'
      endif
    endfor                      ; loop over extractors
                                ;if (self.operator ne OP_NONE) then self.title = self.title + 'operator:' + operator_names[self.operator]
                                ;self.title = self.title+'!C'

;    if (self.operator eq OP_SUMMATION) then self.title ='!C'+ self.sumtitle+'!C'
    if (self.operator eq OP_SMOOTH) then self.title=self.title+'!C(Smoothed with interval of '+strtrim(self.smooth_width,2)+' time points)'
    self.title = strcompress(self.title)


                                ; logarithmic scale ?
    self.xlog = 0
    self.ylog = 0
    if (self.icy eq MYLEV) then begin
       if (ncfiles->is_cflag_set(ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) then self.ylog = 1
    endif

    ; this gives the option to produce 1d plots on log scale.
    pstruct = geov_get_bit_struct(self.ptype)
    if (pstruct.xbit eq VARBIT ) then begin
      if self.auto_log_linear eq 1 then self.xlog = 1
    endif else if ( pstruct.ybit eq VARBIT) then begin
      if self.auto_log_linear eq 1 then self.ylog = 1
    endif

                                ; colors
;    white = self.color_manager->get_white()
;    black = self.color_manager->get_black()
;    if (!d.name eq 'PS') then begin
;       !p.background = white
;       self.col_titles = black
;       self.col_contours =  black
;       self.col_overplot = white
;       self.col_colorbar = black
;       self.col_continents = white
;       self.col_grid = black
;    endif else begin
;       !p.background =  black
;       self.col_titles = white
;       self.col_contours =  black
;       self.col_overplot = white
;       self.col_colorbar = white
;       self.col_continents = white
;       self.col_grid = black
;    endelse
    FOR i=1L, n_elements(self.drawcolors)-1 DO BEGIN
       dummy = fsc_color(self.drawcolors[i], !D.Table_Size-i)
    ENDFOR


 END
