FUNCTION make_levels, data, missing=missing, autolinear=autolinear, autolog=autolog
  @geov_pars

  max_edges = MAXEDGES

  ; initialize parameters
  positive = 0
  negative = 0
  indefinite=0

  ; check if uniform field
  zmin = min(*data, max=zmax)

  if (zmin eq zmax) then begin
      ; throw error
      print,string('WARNING in make_leveles: uniform field=',zmin)
      return,ptr_new([zmin-1.,zmax+1.])
  endif
   
  ; count data values which are zeros or missing
  nelements = n_elements(*data)
  indexes = where(*data eq 0, zerovals)
  if (keyword_set(missing)) then begin
     indexes = where(*data eq missing, nmissing)
  endif

  ; find minima and maxima separately for data >< 0
  indexes = where(*data lt 0, negvals) 
  if (negvals gt 0) then negmin = min((*data)[indexes],max=negmax)
  indexes = where(*data gt 0, posvals)
  if (posvals gt 0) then posmin = min((*data)[indexes],max=posmax)

  ; determine absolute minimum and maximum
  if (negvals eq 0) then begin
      zmin = posmin
      zmax = posmax
  endif else if (posvals eq 0) then begin
      zmin = negmin
      zmax = negmax
  endif else begin
      zmin = negmin
      zmax = posmax
  endelse

  ; non-negative definite field
  if (negvals eq 0) then begin
    positive = 1
    lgmax = alog10(zmax)
    lgmin = alog10(zmin)
    interval=lgmax-lgmin

  ; non-positive definite field
  endif else if (posvals eq 0) then begin
    negative = 1
    zmax = abs(negmin)
    zmin = abs(negmax)
    lgmax = alog10(zmax)
    lgmin = alog10(zmin)
    interval = lgmax-lgmin
    
  ; positive and negative field 
  endif else begin
    indefinite = 1
    interval = alog10(posmax/posmin)+abs(alog10(negmax/negmin))

  endelse

  ; Rolando wants all levels for linear scaling to be
  ; evenly spaced.  For data that contains both neg and pos
  ; values, this will force all levels to be evenly spaced.
  shift = 0
  if ( keyword_set( autolinear ) and indefinite ) then begin
    absmin = zmin
    zmax = zmax-zmin
    zmin = 0.0d
    positive = 1
    negitive = 0
    zerovals = 0
    indefinite = 0
    shift = 1
  endif
    

  ; set contour levels
  if (indefinite ne 1) then begin

      error = set_levels(interval, zmin, zmax, max_edges, positive, negative, zerovals, levels, autolinear=autolinear, autolog=autolog, absmin=absmin)
      if (error ne 0) then begin
          print,'ERROR from set_levels'
          return, ptr_new() ; null pointer
      endif

  endif else begin

      ; do negative values
      lgmax = alog10(abs(negmin))
      lgmin = alog10(abs(negmax))
      interval=lgmax-lgmin
      error = set_levels(interval, abs(negmax), abs(negmin), fix(max_edges/2), 0, 1, zerovals, neglevels, autolinear=autolinear, autolog=autolog)
      if (error ne 0) then begin
          print,'ERROR from set_levels'
          return, ptr_new() ; null pointer
      endif

      ; do positive values
      lgmax = alog10(posmax)
      lgmin = alog10(posmin)
      interval=lgmax-lgmin
      error = set_levels(interval, posmin, posmax, fix(max_edges/2), 1, 0, zerovals, poslevels, autolinear=autolinear, autolog=autolog)
      if (error ne 0) then begin
          print,'ERROR from set_levels'
          return, ptr_new() ; null pointer
      endif

      ; combine the two arrays
      nlevels = n_elements(*neglevels)+n_elements(*poslevels)
      if (zerovals ne 0) then nlevels = nlevels-1 ; since both groups contain 0
      levels = ptr_new(fltarr(nlevels))
      (*levels)[0:n_elements(*neglevels)-1] = (*neglevels)[0:n_elements(*neglevels)-1]
      if (zerovals eq 0) then (*levels)[n_elements(*neglevels):nlevels-1] = (*poslevels)[0:n_elements(*poslevels)-1] $
      else                    (*levels)[n_elements(*neglevels):nlevels-1] = (*poslevels)[1:n_elements(*poslevels)-1]

      ; deallocate memory from sub-arrays
      ptr_free, neglevels
      ptr_free, poslevels

  endelse

  return, levels ; pointer to levels

END
