FUNCTION geov_preferences::get_win_auto_raise
    return, self.auto_win_raise
END

FUNCTION geov_preferences::get_data_dirs
    return, self.data_dirs
END

FUNCTION geov_preferences::get_window_size, window_size
  ; check if window_size is a string or a pair of (float) values
  ; if none is provided, use self.window_size as default
  IF n_elements(window_size) EQ 0 THEN return, self.window_size

  IF size(window_size, /TName) EQ 'STRING' THEN BEGIN 
     CASE strlowcase(window_size) OF 
;        'tiny'   : thewindow_size = [ 0.25, 0.20 ]
;        'small'  : thewindow_size = [ 0.45, 0.30 ]
;        'medium' : thewindow_size = [ 0.50, 0.45 ]
;        'large'  : thewindow_size = [ 0.80, 0.60 ]
;        'huge'   : thewindow_size = [ 0.95, 0.80 ]
; Rolando's sizes
        'tiny'   : thewindow_size = [ 0.25, 0.20 ]
        'small'  : thewindow_size = [ 0.40, 0.35 ]
        'medium' : thewindow_size = [ 0.45, 0.40 ]
        'large'  : thewindow_size = [ 0.55, 0.45 ]
        'huge'   : thewindow_size = [ 0.65, 0.55 ]

        ELSE : BEGIN 
           message, 'Invalid window size specification ('+window_size+')!',/CONTINUE
           print,'% Will use medium size ...'
           thewindow_size = [ 0.50, 0.45 ]
        ENDELSE 
     ENDCASE 
  ENDIF ELSE BEGIN 
     thewindow_size = float(window_size)
     IF n_elements(thewindow_size) LT 2 THEN $
        thewindow_size = [ 1.0, 0.85 ] * thewindow_size
     thewindow_size = thewindow_size[0:1]
  ENDELSE  
  return, thewindow_size
END

FUNCTION geov_preferences::get_plot2d_position
    return, self.plot2d_position
END

FUNCTION geov_preferences::get_plot1d_position
    return, self.plot1d_position
END

FUNCTION geov_preferences::get_bar_position
    return, self.bar_position
END

FUNCTION geov_preferences::get_charsize
    return, self.charsize
END

FUNCTION geov_preferences::get_ps_landscape
    return, self.ps_landscape
END

FUNCTION geov_preferences::get_plot_type
    return, self.plot_type
END

FUNCTION geov_preferences::get_map_type
    return, self.map_type
END

FUNCTION geov_preferences::get_contour_opt
    return, self.contour_opt
END

FUNCTION geov_preferences::get_dateformat
    return, self.dateformat
END

Function  geov_preferences::get_default_calendar
  return, self.default_calendar
End

; simple class to store user preferences for GEOV package
PRO geov_preferences__define

  struct = { geov_preferences,             $ ; class name
             data_dirs:ptr_new(),          $ ; array of valid data directories
             window_size:fltarr(2),        $ ; default window size for plotting
             plot2d_position:fltarr(4),    $ ; position of plot in 2D window
             plot1d_position:fltarr(4),    $ ; position of plot in 1D window
             bar_position:fltarr(4),       $ ; position of colorbar
             charsize:0.,                  $ ; default character size
             ps_landscape:0L,              $ ; orientation for postscript output
             plot_type:0L,                 $ ; identifier for default plot type
             map_type:0L,                  $ ; map type (0 = no map)
             contour_opt:0L,               $ ; contour option
             dateformat:'',                $ ; format string for date labels (see LABEL_DATE)
             auto_win_raise:0L,            $ ; flag to bring wins to top
             default_calendar:''           $ ; the default calendar
           }
END
