; method to set new coordinate limits for plotting
; input: coordinate vertexes in IDL data coordinates
; (for maps, this means longitudes always range from -180 to 180)
FUNCTION geov_zoomer::zoom_circle, west_point, north_point, east_point, south_point
   @geov_pars

   ;print,'WEST_POINT=', west_point
   ;print,'NORTH_POINT=', north_point
   ;print,'EAST_POINT=', east_point
   ;print,'SOUTH_POINT=', south_point

   ; use only point latitude
   nlat = north_point[1]
   slat = south_point[1]

   ; check new latitude is valid
   if (finite(nlat) eq 0 or finite(slat) eq 0) then begin
       message,string('INVALID ZOOMING LATITUDE')
       return, 1
   endif

   ; increment zoom counter, if possible, and keep track of previous zoom
   pzoom = self.izoom
   max_zooms = n_elements(self.cminima[0,*])
   if (self.izoom lt max_zooms-1) then self.izoom = self.izoom+1

   ; copy previous limits into new ones
   self.cminima[*,self.izoom] = self.cminima[*,pzoom]
   self.cmaxima[*,self.izoom] = self.cmaxima[*,pzoom]
   self.map_limits[*,self.izoom] = self.map_limits[*,pzoom]
   self.map_center[*,self.izoom] = self.map_center[*,pzoom]

   ; override with new latitude
   ptype = self.plotter->get_ptype()
   CASE ptype OF
        MAP_NP: BEGIN
                   self.cminima[MYLAT,self.izoom] = nlat
                   self.map_limits[0,self.izoom] = nlat
                END
        MAP_SP: BEGIN
                   self.cmaxima[MYLAT,self.izoom] = slat
                   self.map_limits[2,self.izoom] = slat
                END
        MAP_GP: BEGIN
                   ; assign limits only if represent restriction from previous limits,
                   ; and still contain the map center
                   if (slat gt self.map_limits[0,self.izoom] and slat lt self.map_center[0,self.izoom]) then begin
                       self.cminima[MYLAT,self.izoom] = slat
                       self.map_limits[0,self.izoom] = slat
                   endif
                   if (nlat lt self.map_limits[2,self.izoom] and nlat gt self.map_center[0,self.izoom]) then begin
                       self.cmaxima[MYLAT,self.izoom] = nlat
                       self.map_limits[2,self.izoom] = nlat
                   endif
                END
   ENDCASE

   return, 0

END
