FUNCTION hank_ncfile::INIT, filename

  ; superclass constructor
  ok = self->ncfile::INIT(filename)
  if (ok) then begin

     ; initialize
     self.ix        = -1
     self.iy        = -1
     self.ilev      = -1
     self.ilev_edge = -1
     self.itime     = -1
     self.missing=-1.E36

     ; identify coordinates by name
     for id=0, self.ndims-1 do begin
         dname = strlowcase( (*self.dnames)[id] )
              if (dname eq 'x')         then self.ix         = id $
         else if (dname eq 'y')         then self.iy         = id $
         else if (dname eq 'lev')       then self.ilev       = id $
         else if (dname eq 'lev_edge')  then self.ilev_edge  = id $
         else if (dname eq 'time')      then self.itime      = id
     endfor

     ; parse global attributes
     for igatt=0,self.ngatts-1 do begin
       attname = ncdf_attname(self.fid, /global, igatt)
       ncdf_attget, self.fid, /global, attname, attvalue
       if (attname eq 'x') then self.dx = float(parse_string(string(attvalue),before='size',after='km'))
       if (attname eq 'y') then self.dy = float(parse_string(string(attvalue),before='size',after='km'))
       if (attname eq 'projection') then self.projection = parse_string(string(attvalue))
       if (attname eq 'proj_params') then begin
           self.lat0 = float(parse_string(string(attvalue),before='lat0 ',after='lon0'))
           self.lon0 = float(parse_string(string(attvalue),before='lon0 ',after=' '))
       endif
     endfor

  endif
  return, ok
END
