; method to take difference of two datasets
; data missing values must be substituted with !values.f_nan before calling this method
FUNCTION operator_difference, ap, bp
  
  ; check for compatibility
  if (operator_check(ap,bp)) then begin

      ; allocate new memory
      cp = ptr_new(*ap) 

      ; check for missing values
      good_indexes = where((finite(*ap) eq 1) and (finite(*bp) eq 1), ngood)
      bad_indexes = where((finite(*ap) eq 0) or (finite(*bp) eq 0), nbad)

      if (ngood gt 0) then begin
          (*cp)[good_indexes] = (*ap)[good_indexes] - (*bp)[good_indexes]
      endif

      if (nbad gt 0) then (*cp)[bad_indexes] = !values.f_nan

      return, cp

  endif else return, ptr_new() ; error: return invalid pointer

END
