Pro operator_smooth_event, event

  widget_control, event.top, get_uvalue=info

  case event.id of
    (*info).ok_wid:   	begin

                          widget_control, (*info).width_field, get_value=width

                          (*info).width = fix( width[0] )

                          (*info).cancel = 0

                          ok = (*info).width gt 0

                          if (ok) then begin
                            widget_control,event.top,/destroy
                          endif

                        end
    (*info).cancel_wid:	widget_control,event.top,/destroy
    else:
  endcase


End
; smooth in the time dimension
function operator_smooth, data_ptr,group_leader=group_leader, width=width

  if n_elements(group_leader) gt 0 then modal=1 else modal=0
  topbase = widget_base( title='Smooth Operator Width', tlb_frame_att=3,modal=modal,$
                        group_leader=group_leader, /column )
  
  width_field = cw_field( topbase, title='Enter the smoothing window width.', $
                        xsize=20, ysize=1, fieldfont=thisfont, font=thisfont ,/column  $
                        )

  if ( n_elements(width) gt 0 ) then begin
     w = fix(width)
     widget_control, width_field, set_value=width
  endif else w = 0

  if (w eq 0) then begin
    widget_control, topbase, set_uvalue=info ;, /no_copy

    rowbase = widget_base( topbase, /row)

    acceptid = widget_button( rowbase, value='OK' )

    cancelid = widget_button( rowbase, value='Cancel' )

    info = ptr_new({ ok_wid:acceptid, $
                   cancel_wid:cancelid, $
                   cancel:1, $
                   width_field:width_field, $
                   width:0 $
                 })

    widget_control, topbase, set_uvalue=info 

    widget_control, topbase, default_button=acceptid, cancel_button=cancelid

    widget_control, topbase, /realize

    xmanager, 'operator_smooth', topbase

    if ( (*info).cancel ne 0 ) then return, data_ptr

    w = (*info).width
  endif 

  ndims = (size( *data_ptr))[0]

  s = intarr(ndims)
  s[*] = 1
  s[0] = w
  smooth_data = smooth( *data_ptr, s, /EDGE_TRUNCATE )

  width = strtrim(string(w),2)

  return, ptr_new( smooth_data )

end

pro test_operator_smooth

  data_ptr = ptr_new( findgen( 32,3,3) )

  width=''
  sdata_ptr = operator_smooth( data_ptr ,width=width )

  print,*data_ptr
print,'----------------------------------------------------'
  print,*sdata_ptr

help, width

end
