PRO archive_manager::build_gui

    ; to prevent flickering or flashing while gui is being built and
    ; repositioned on screen
    widget_control, self.base_wid, map=0, update=0

;mgs++
    tmpbase = widget_base(self.base_wid, /column, /frame)

    tmp = widget_label(tmpbase, $
                       value='Choose data file starting from directory:', $
                       /align_center)

    maxlen = Max(StrLen(*self.data_dirs))
    for i=0, n_elements(*self.data_dirs)-1 do begin
        tmp = widget_button(tmpbase, $
                            /align_center, $
                            value=(*self.data_dirs)[i], $
                            xsize=(maxlen+2)*8, $
                            uvalue=self)
    endfor
    ;; store last directory widget for future changes
    self.lastdirwid = tmp
    note = ['NOTE: More than one file may be selected    ' , $
            'if the files are compatible and consecutive.' ]

    notewid = widget_text( tmpbase, value=note,xsize=strlen(note[0]), ysize=n_elements(note) ,frame=0)

    tmpbase = widget_base(self.base_wid, /row, /align_center)

    quit_wid = widget_button(tmpbase, $
                             /align_center, $
                             value='Quit GEOV', $
                             xsize = 11*8, $
                             uvalue=self)

    exit_wid = widget_button(tmpbase, $
                             /align_center, $
                             value='Exit IDL', $
                             xsize=11*8, $
                             uvalue=self)
;mgs--
END
