; method to load colors specified by name into current color table
; NOTE: color table will be modified and later needs to be reloaded
FUNCTION color_manager::load_colors, color_names

  ncolors = n_elements(color_names)
  for i=0,ncolors-1 do begin

      ; map color name onto predefined indexes
      CASE strlowcase(color_names[i]) OF
           'red'           : color_index=self.red
           'green'         : color_index=self.green
           'blue'          : color_index=self.blue
           'dark_red'      : color_index=self.dark_red
           'light_red'     : color_index=self.light_red
           'red_yellow'    : color_index=self.red_yellow
           'red_magenta'   : color_index=self.red_magenta
           'dark_green'    : color_index=self.dark_green
           'light_green'   : color_index=self.light_green
           'dark_blue'     : color_index=self.dark_blue
           'light_blue'    : color_index=self.light_blue
           'yellow'        : color_index=self.yellow
           'dark_yellow'   : color_index=self.dark_yellow
           'light_yellow'  : color_index=self.light_yellow
           'gray'          : color_index=self.gray
           'dark_gray'     : color_index=self.dark_gray
           'cyan'          : color_index=self.cyan
           'light_cyan'    : color_index=self.light_cyan
           'dark_cyan'     : color_index=self.dark_cyan
           'magenta'       : color_index=self.magenta
           'light_magenta' : color_index=self.light_magenta
           'dark_magenta'  : color_index=self.dark_magenta
           'green_cyan'    : color_index=self.green_cyan
           'green_yellow'  : color_index=self.green_yellow
           'blue_magenta'  : color_index=self.blue_magenta
           'blue_cyan'     : color_index=self.blue_cyan
           'light_gray'    : color_index=self.light_gray
           'light_violet'  : color_index=self.light_violet
           'violet'        : color_index=self.violet
           'dark_violet'   : color_index=self.dark_violet
           'pea'           : color_index=self.pea
           'mandarin'      : color_index=self.mandarin
           'light_reddish' : color_index=self.light_reddish
           'dark_reddish'  : color_index=self.dark_reddish
           'white'         : color_index=self.white
      ELSE                 : color_index=self.black ; default color loaded
      ENDCASE

      ; load this color at position i+1 into current color table
      tvlct, (*self.mycolors)[color_index,0:2], i+1 
  endfor

  return, (1+bindgen(ncolors)) ; colors are loaded into locations 1..ncolors

END
