; convenience method to store the IDL color table loaded by XLOADCT
PRO set_idlct, data=data
    common idl_color_table, idlct
    idlct = data
END

; method to load colors for image plot
PRO color_manager::loadidlct, choose=choose, table=table
  common idl_color_table, idlct
  @geov_pars

  if (!d.n_colors gt 256 and strlowcase(!d.name) ne 'ps') then device,decompose=0

  ; select IDL color table from (modified) XLOADCT
  if (keyword_set(choose)) then begin
      idlct = -1
      myxloadct,/block,updatecallback='set_idlct',updatecbdata=idlct
      ; check user hasn't just quit the widget
      if (idlct ge 0) then self.color_table = idlct

  ; load given IDL color table
  endif else if (n_elements(table) gt 0) then begin
      loadct, table
      self.color_table=table

  ; reload cureent IDL color table
  endif else begin
      loadct, self.color_table

  endelse

;print,'########### override first and last color ###############'
;  tvlct, 0, 0, 0, 0                     ; override first location with black
;  tvlct, 255, 255, 255, !d.table_size-1 ; override last location with white

END
