PRO print_manager::CLEANUP

    if (self.output eq 'ps' or self.output eq 'eps') then begin

        ; close postscript device
        device, /close

        ; restore previous device
        set_plot,self.saved.dname
        !p.font=self.saved.pfont

    endif else if (self.output eq 'png' or self.output eq 'jpg') then begin

        ; capture the current image from screen
        ;frame = bytarr(!d.x_size,!d.y_size)
        ;frame = tvrd(true=1)
        frame = tvread() ;  a more robust read

        ; write image to file
        if (self.output eq 'jpg') then begin
            image3D = bytscl(frame)
            write_jpeg,self.filename,image3D,true=1,quality=100 ; best possible quality
        endif else if (self.output eq 'png') then begin
            image2D = color_quan(frame, 1, r, g, b)
            if (float(!version.release) lt 5.4) then image2D = reverse(image2D,2)
            write_png,self.filename,image2D, r, g, b
        endif

    endif

END
