FUNCTION print_manager::INIT, output, landscape=landscape, savepath=savepath, get_savepath=get_savepath
  
  self.output = output

  ; ask for output file name
  default_filename = 'idl.'+self.output
  self.filename = DIALOG_PICKFILE(file=default_filename, $
                                  filter='./*.'+self.output, /fix_filter, $  ; mgs++-- removed OUTPUT
                                  title='Output filename?', $
                                  path=savepath, $
                                  get_path = get_savepath )
  if (self.filename eq '') then return, 0
  junk = FINDFILE(self.filename, count=count)
  if (count ne 0) then begin
      answer = DIALOG_MESSAGE('This file already exists, do you want to overwrite it?',/question)
      if (answer eq 'No') then return, 0
  endif

  if (self.output eq 'ps' or self.output eq 'eps') then begin

    ; save previous device specifications for later restoring
    self.saved.dname= !d.name
    self.saved.pfont= !p.font

    ; switch device to postscript
    set_plot,'ps'

    ; switch from vector-drawn fronts to postscript fonts
    !p.font=1

    ; set postscript device parameters
    if (self.output eq 'eps') then encaps=1 else encaps=0
    device, filename=self.filename, $
         ;;   set_font='Helvetica-Bold', /TT_FONT, $  ;;  mgs++--  'Times-Bold', $
            ;/times, $
            /helvetica, $
            encaps=encaps, $
            bits_per_pixel=8, $
            ;portrait=0, $
            landscape=landscape, $  ; from keyword
            ;encaps=encaps, portrait=encaps, landscape=not encaps, $
            color=1

  endif

  return, 1

END
