Function geov_version
  return , '4.8d'
End

Function geov_info
  return , [ $
  '-------------------------------------------------------------------------',$
  ' GEOV: IDL-based viewer for geophysical data in netCDF format            ',$
  ' Luca Cinquini, Martin Schultz, Francis Vitt, Stacy Walters              ',$
  '-------------------------------------------------------------------------',$
  ' This program is free software;  you can redistribute it and/or modify   ',$
  ' it under the terms of the GNU General Public License as published by the',$
  ' Free Software Foundation;  either version 2 of the license, or (at your ',$
  ' option) any later version.                                              ',$
  ' The GEOV package is distributed in the hope that it will be useful, but ',$
  ' WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-',$
  ' LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public   ',$
  ' License for more details.                                               ',$
  ' To obtain a copy of the GNU General Public License, write to:           ',$
  ' Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. ',$
  '-------------------------------------------------------------------------',$
  ' Author contact information:                                             ',$
  '                                                                         ',$
  ' Stacy Walters, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA     ',$
  ' email:  stacy@ucar.edu                                                  ',$
  '                                                                         ',$
  ' Francis Vitt, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA      ',$
  ' email:  fvitt@ucar.edu                                                  ',$
  '                                                                         ',$
  ' Luca Cinquini, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA     ',$
  ' email:  luca@ucar.edu                                                   ',$
  '                                                                         ',$
  ' Martin Schultz, MPI-Met, Bundesstr. 55, 20146 Hamburg                   ',$
  ' email: martin.schultz@dkrz.de                                           ',$
  '                                                                         ',$
  '-------------------------------------------------------------------------',$
  ' Copyright (C) 2001  University Corporation for Atmospheric Research     ',$
  '                     and Max Planck Institute for Meteorology, Hamburg   ',$
  '-------------------------------------------------------------------------' $
  ]
End


; ==========  include two library routines to avoid !path problems =========

; routine_name: return the name of the currently active routine and the filename
; from where it has been compiled

function routine_name,filename=filename,caller=caller

   ; extract the name of the current routine from the caller stack
   ; the first element will always be ROUTINE_NAME ;-)
   help,call=c

   caller = keyword_set(caller)
   i = 1 + caller
   if (i ge n_elements(c)) then return,'No caller for $MAIN$'

   thisroutine = strsplit(strcompress(c[i])," ", /EXTRACT)

   if (n_elements(thisroutine) gt 1) then filename = thisroutine[1] $
   else filename = ''

   ; cut < and ( brackets from filename info
   len = strlen(filename)
   filename = strmid(filename,1,len-2)

return,strlowcase(thisroutine[0])
end

; extract_path: seperate the filename from the directory information

function extract_path,fullname,filename=filename

; determine path delimiter
    if (strcmp(!version.os_family,'windows',/fold_case) eq 1) then sdel = '\' else sdel = '/'

    path = ''
    filename = ''

retry:
; look for last occurence of sdel and split string fullname
    p = strpos(fullname,sdel,/Reverse_Search)

; extra Windows test: if p=-1 but fullname contains '/', retry
    if (p lt 0 AND strpos(fullname,'/') ge 0) then begin
       sdel = '/'
       goto,retry
    endif

    if (p ge 0) then begin
       path = strmid(fullname,0,p+1)
       filename = strmid(fullname,p+1,strlen(fullname)-1)
    endif else $
       filename = fullname


return,path

end

; ==========  this is the geov_init routine ================================
PRO igeov

  defsysv, '!geov_version', exists=geov_forever
  if not geov_forever then defsysv, '!geov_version', geov_version()

  dummy = routine_name(file=geovfile)
  parentdir = extract_path(geovfile)

  print,'GEOV version '+String(!geov_version)+', parentdir = ',parentdir
  if (strpos(!path,parentdir+'geov') lt 0) then !path = !path + ':' + expand_path('+' + parentdir)

  ; set IDL to not warn about math exceptions
  !EXCEPT=0

  ; start GUI for file selection
  manager = obj_new('geov_manager')

END
