pro CALDAT_365, julian, month, day, year, hour, minute, second

mdays = [1,32,60,91,121,152,182,213,244,274,305,335]

year = floor( julian/365.d ) + 1

doy = floor( julian - (year-1)*365.d ) + 1

dayfrac = julian - (year-1)*365.d - doy + 1d

hour = floor( 24.d * dayfrac )

minute = floor( (dayfrac-hour/24.d)*1440.d )

second = ( dayfrac - hour/24.d - minute/1440.d ) *86400.d

n=n_elements(doy)

for i=0,n-1 do begin
  ind = where( mdays le doy[i] , m )
  d = doy[i] - mdays[m-1] + 1
  if (i gt 0) then month = [month, m ] else month = m
  if (i gt 0) then day = [day, d ] else day = d
endfor

end

pro test_caldat_365

 j = [-365.d,.23d, 34534500.524523d]
; j = 345345932.d

caldat_365, j, m,d,y,h,i,s

print,'---------------------------'
help,m,d,y,h,i,s
print,'year = ',y
print,'month = ',m
print,'day ',d
print,'hour = ',h
print,'minute = ',i
print,'second = ',s


end
