pro mycolorbar,cols,vals,position, $ 
    format=format, charsize=charsize, vertical=vertical, textcolor=textcolor
   
    ; defaults
    if (not keyword_set(charsize)) then charsize = 1.0
    if (not keyword_set(textcolor)) then textcolor = 0  ; first color available

    ncols = n_elements(cols)   
    nvals = n_elements(vals)
    IF nvals LT 3 THEN return 

    orientation = 0
    align = 0.
    if (not keyword_set(format)) THEN BEGIN
       ;; determine "nice" label format automatically
       ;; format = '(G10.2)'
       mmin = min(vals[1:nvals-2])
       mmax = max(vals[1:nvals-2])
       amin = min(abs(vals[1:nvals-2]))
       amax = max(abs(vals[1:nvals-2]))
       format = '(i4)'
       fsize = 0
       ;; test for range of values
       IF (mmax-mmin) GT 999. OR (mmax-mmin) LT 0.01 THEN fsize = 1
       IF (mmax-mmin) GT 9999. OR (mmax-mmin) LT 0.001 THEN fsize = 2
       ;; test for range of abs values
       IF (amax-amin) GT 999. OR (amax-amin) LT 0.01 THEN fsize = fsize > 1
       IF (amax-amin) GT 9999. OR (amax-amin) LT 0.001 THEN fsize = fsize > 2
       ;; check narrowness of first two values
       IF abs(abs(vals[2])-abs(vals[1])) LT 0.9 THEN fsize = fsize > 2
       ;; set label properties
       IF fsize GE 1 THEN orientation = 270
       IF (amax-amin) LT 3 THEN format='(f8.3)'
       IF (amax-amin) LT 11 THEN format='(f8.2)'
       IF (amax-amin) LT 23 THEN format='(f8.1)'
       IF abs(fsize) GE 2 THEN format = '(g11.3)'
    ENDIF 
   

    cbxmin = position[0]
    cbymin = position[1]
    cbxmax = position[2]
    cbymax = position[3]
    lbly = cbymin

    ;; convert vals to string
    svals = string(vals, format=format)
    IF nvals EQ ncols+1 THEN BEGIN 
       svals[0] = '      ' ;; -inf'
       svals[ncols] = '      ' ;; 'inf'
    ENDIF 
    WHILE min(strpos(svals, ' ')) GE 0 DO svals = strmid(svals,1)
    IF orientation EQ 0 AND keyword_set(vertical) EQ 0 THEN BEGIN 
       svals = STrTrim(svals,2)
       align = 0.5
       lbly = cbymin - 0.03
    ENDIF 
 
    ; VERTICAL COLORBAR
    if (keyword_set(vertical)) then begin

      dy = (cbymax-cbymin)/float(ncols)

      for i=0,ncols-1 do begin
        y1 = cbymin+dy*i
        y2 = cbymin+dy*(i+1)
        polyfill, [cbxmin, cbxmin, cbxmax, cbxmax], [y1, y2, y2, y1], $
                  color=cols[i], $
                  /normal
        plots, [cbxmin, cbxmin, cbxmax, cbxmax, cbxmin], [y1, y2, y2, y1, y1], color=textcolor, /normal
        if (nvals eq ncols+1) then begin ; write on edges
            xyouts,cbxmax+0.003,y1,svals[i],/normal,color=textcolor,charsize=charsize
        endif else begin ; write on centers
            xyouts,cbxmax+0.003,0.5*(y1+y2)-0.005,svals[i],/normal,color=textcolor,charsize=charsize
        endelse
      endfor
      if (nvals eq ncols+1) then $ ; write last edge
        xyouts,cbxmax+0.003,y2,svals[ncols],/normal,color=textcolor,charsize=charsize

    ; HORIZONTAL COLORBAR
    endif else begin

      dx = (cbxmax-cbxmin)/float(ncols)
    
      for i=0,ncols-1 do begin
        x1 = cbxmin+dx*i
        x2 = cbxmin+dx*(i+1)
        polyfill, [x1, x2, x2, x1], [cbymin, cbymin, cbymax, cbymax], $
                  color=cols[i], $
                  /normal
        plots, [x1, x2, x2, x1, x1], [cbymin, cbymin, cbymax, cbymax, cbymin], color=textcolor, /normal
        xyouts, x1, lbly, svals[i], $
           /normal,color=textcolor,charsize=charsize, $
           orientation=orientation, align=align
      endfor
      if (nvals eq ncols+1) then $ ; write last edge
         xyouts, x1+dx, lbly, svals[ncols], $
         /normal,color=textcolor,charsize=charsize, $
         orientation=orientation, align=align
      
    endelse

end
