; object to extract and store data from netCDF file
PRO geov_extractor__define
    @geov_pars

    struct = { geov_extractor,                  $
               gui:obj_new(),                   $ ; reference to geov_gui object from which import selection
               ncfiles:obj_new(),                $ ; reference to netCDF file from which to extract data

               ; variables containing file-specific user selection
               vid:0L,                          $ ; id of variable to be plotted
               ipvar:0L,                        $ ; alphabetical index of plotting variable
               icoords:ptr_new(),               $ ; array containing user selection for each coordinate
               actions:ptr_new(),               $ ; action code for each coordinate
               scale_factor:0.,                 $ ; variable scale factor (1E-6, 1E-9, 1E-12)

               colflag:0L,                      $ ;
               numflag:0L,                      $ ;
               tmassflag:0L,                      $ ;

	           ; data arrays
               xs:ptr_new(),                    $ ; pointer to values for X axis
               ys:ptr_new(),                    $ ; pointer to values for Y axis
               data:ptr_new(),                  $ ; data array
               ; mgs 22 April 2002
               uwind:ptr_new(),                 $ ; wind vector u component
               vwind:ptr_new()                  $ ; wind vector v component


    }

END
