PRO geov_extractor::import_all, fromindex
    @geov_pars
    p2coords = (self.ncfiles)->get_p2coords()
    if (p2coords[MYLAT] ge 0) then self->import_lat, fromindex
    if (p2coords[MYLON] ge 0) then self->import_lon, fromindex
    if (p2coords[MYLEV] ge 0) then self->import_lev, fromindex
    if (p2coords[MYTIM] ge 0) then self->import_time, fromindex
    self->import_ipvar, fromindex
END

PRO geov_extractor::import_lat, fromindex
    ; retrieve lat selection from associated gui
    indexes = self.gui->get_lat()

    ; single selection --> always import from index 0
    if (n_elements(indexes) eq 1) then begin
        self->set_lat, indexes[0]

    ; double selection: import from index fromindex
    endif else if (n_elements(indexes) eq 2) then begin
        self->set_lat, indexes[fromindex]

    endif
END

PRO geov_extractor::import_lon, fromindex
    ; retrieve lon selection from associated gui
    indexes = self.gui->get_lon()

    ; single selection --> always import from index 0
    if (n_elements(indexes) eq 1) then begin
        self->set_lon, indexes[0]

    ; double selection: import from index fromindex
    endif else if (n_elements(indexes) eq 2) then begin
        self->set_lon, indexes[fromindex]

    endif
END

PRO geov_extractor::import_lev, fromindex
    ; retrieve lev selection from associated gui
    indexes = self.gui->get_lev()

    ; single selection --> always import from index 0
    if (n_elements(indexes) eq 1) then begin
        self->set_lev, indexes[0]

    ; double selection: import from index fromindex
    endif else if (n_elements(indexes) eq 2) then begin
        self->set_lev, indexes[fromindex]

    endif
END

PRO geov_extractor::import_time, fromindex
    ; retrieve time selection from associated gui
    indexes = self.gui->get_time()

    ; single selection --> always import from index 0
    if (n_elements(indexes) eq 1) then begin
        self->set_time, indexes[0]

    ; double selection: import from index fromindex
    endif else if (n_elements(indexes) eq 2) then begin
        self->set_time, indexes[fromindex]

    endif
END

PRO geov_extractor::import_ipvar, fromindex
    ; retrieve lat selection from associated gui
    indexes = self.gui->get_ipvar()

    ; single selection --> always import from index 0
    if (n_elements(indexes) eq 1) then begin
        self->set_var, indexes[0]

    ; double selection: import from index fromindex
    endif else if (n_elements(indexes) eq 2) then begin
        self->set_var, indexes[fromindex]

    endif
END

PRO geov_extractor::import
END
