pro pressure_entry_event, event

  widget_control, event.top,get_uvalue=pState
  widget_control, event.id, get_value=val

  case strupcase( val[0] ) of

    'ACCEPT':  begin
                 widget_control,(*pState).expression, get_value=expr
                 (*pState).out.expr = string( expr[0] )
                 (*pState).out.cancel = 0
                 widget_control,event.top,/destroy
               end

    'CANCEL':  widget_control,event.top,/destroy

    ELSE:

  endcase

end

function pressure_entry, group_leader=group_leader, pressure=pressure

start:

  tbl = widget_base( /col, title='Pressure entry', tlb_frame_attr=1,$
                     /modal,group_leader=group_leader )

  if ( STRCMP(!VERSION.OS_FAMILY , 'win', 3,/fold_case) ) then thisFont = 'Courier*16*Bold'
  if ( STRCMP(!VERSION.OS_FAMILY , 'unix',4,/fold_case) ) then thisFont = '10x16bold'
  
  expression = cw_field( tbl, title='Pressure (mb)', /col, $
                         xsize=50, ysize=1, fieldfont=thisFont, font=thisFont)
  
  rowBase = widget_base(tbl,/row)
  acceptid= widget_button(rowBase, value='Accept')
  cancelid= widget_button(rowBase, value='Cancel')

  widget_control, tbl, default_button=acceptid,  cancel_button=cancelid

  widget_control, tbl, /realize

  if (keyword_set(pressure)) then begin
    widget_control, expression, set_value=string( pressure, format='(F10.4)' )
  endif

  out={expr:'',cancel:1}
  state={out:out,expression:expression}
  pState=ptr_new(state,/no_copy)
  widget_control,tbl,set_uvalue=pState

  xmanager,'pressure_entry',tbl

  stateInfo = *pState
  ptr_free, pState

  if ( stateInfo.out.cancel ) then return, ptr_new() ; return null ptr

  result = execute('entry = float('+stateInfo.out.expr+')',0)

  if (result eq 0) then begin
    xx=dialog_message('Illegal expression',dialog_parent=group_leader ,/error)
    goto, start
  endif

  return, ptr_new( entry )

end
