; method to select active/ina(*pvbits)[index]ctive widgets
; based on selected variable and plot type
PRO geov_gui::activator, lists=lists, plot_buttons=plot_buttons, plot_is_valid=plot_is_valid
    @geov_pars
    ; always sensitize the following widgets
    widget_control, self.file_menu_wid, sensitive=1
    widget_control, self.display_menu_wid, sensitive=1
    if (self.map_menu_wid ne 0) then widget_control, self.map_menu_wid, sensitive=1
    widget_control, self.plot2d_menu_wid, sensitive=1
    widget_control, self.plot1d_menu_wid, sensitive=1
    widget_control, self.print_menu_wid, sensitive=1

    widget_control, self.pvars_wid, sensitive=1
    valid = widget_info(self.uvwind_wid, /valid_id)
    if (valid) then begin
       widget_control, self.uvwind_wid, sensitive=1
    ENDIF

    widget_control, self.operator_wid, sensitive=1

    nplotters=self.manager->get_number_of_plotters()

    if (nplotters gt 1) then $
      widget_control, self.overplot_wid, sensitive=1 $
    else $
      widget_control, self.overplot_wid, sensitive=0 
   
    widget_control, self.extractor_wid, sensitive=1
    widget_control, self.auto_contour_wid, sensitive=1
    widget_control, self.samescale_wid, sensitive=1

    if (self->get_auto_contour()) then begin
      widget_control, self.auto_log_linear_wid, sensitive=1
    endif else begin
      widget_control, self.auto_log_linear_wid, sensitive=0
    endelse

    widget_control, self.scaling_wid, sensitive=1
    if (self.logp_wid gt 0) then widget_control, self.logp_wid, sensitive=1

    ; coordinate mask of first plotting plotting variable
    pvbits= self.ncfiles->get_pvbits()
    pvmask = ((*pvbits)[self->get_ipvar()])[0]

    ; turn off levels dependence if total column density is selected
    if (self.totcol_flag ne 0) then begin
      pvmask = pvmask and (not LEVBIT)
    endif

    ; if a var is defined on the level interfaces we want
    ; to change the levels values displayed in the levels
    ; list widget
;    ipvar = (self->get_ipvar())[0] ; take first selected var
;    pvars = self.ncfiles->get_pvars() 
;    vid = (*pvars)[ipvar]

    if (self.levs_wid gt 0) then begin

;      if ( self.ncfiles->var_depends_on_ilevi(vid) ) then begin
;        levs = self.ncfiles->get_interface_levs()
;      endif else begin
;        levs = self.ncfiles->get_levs()
;      endelse

;      levselect = widget_info(self.levs_wid,/list_select)
;      widget_control, self.levs_wid, set_value=strtrim(string(*levs,format=self->levs_format(levs)),2)
      self->set_levels_widget
;      if levselect gt n_elements(*levs)-1 then levselect = n_elements(*levs)-1    
;      widget_control, self.levs_wid, set_list_select = levselect
    endif

    ; COORDINATE WIDGETS
    if (keyword_set(lists)) then begin
      if (self.lats_wid gt 0) then begin
        if ( (pvmask and LATBIT) gt 0) then widget_control, self.lats_wid, sensitive=1 $
        else                                widget_control, self.lats_wid, sensitive=0
      endif
      if (self.lons_wid gt 0) then begin
        if ( (pvmask and LONBIT) gt 0) then widget_control, self.lons_wid, sensitive=1 $
        else                                widget_control, self.lons_wid, sensitive=0
      endif
      if (self.levs_wid gt 0) then begin
        if ( (pvmask and LEVBIT) gt 0) then widget_control, self.levs_wid, sensitive=1 $
        else                                widget_control, self.levs_wid, sensitive=0
      endif
      if (self.times_wid gt 0) then begin
        if ( (pvmask and TIMBIT) gt 0) then widget_control, self.times_wid, sensitive=1 $
        else                                widget_control, self.times_wid, sensitive=0
      endif
    endif

    ; PLOT BUTTONS
    if (keyword_set(plot_buttons)) then begin

      ; plot type structure
      ptype_struct = geov_get_bit_struct(self.ptype)

      for ib = 0, n_elements(*self.pbuttons_wid)-1 do begin
        pbstruct = geov_get_bit_struct((*self.pbuttons_values)[ib])


        ; MAP or 2D PLOT: make active or inactive depending only on which coordinates the variable
        ; depends on
        if (pbstruct.xbit ne VARBIT and pbstruct.ybit ne VARBIT) then begin
          if ( (pvmask and (*self.pbuttons_mask)[ib]) eq (*self.pbuttons_mask)[ib] ) then begin
                 widget_control, (*self.pbuttons_wid)[ib], sensitive=1
          endif else begin
            widget_control, (*self.pbuttons_wid)[ib], sensitive=0
          endelse

        ; 1D PLOT: make active or inactive depending on variable dependence,
        ; and on which 2D plot was last selected
        endif else begin

          ; if variable does not have necessary coordinate -> make it inactive
          if ( (pvmask and (*self.pbuttons_mask)[ib]) ne (*self.pbuttons_mask)[ib] ) then begin
               widget_control, (*self.pbuttons_wid)[ib], sensitive=0

          endif else begin ; 1D plot is compatible with variable selection
 
            ; fv - 7 may 2003
            ; don't quite understand this portion of the code...
            ; - seems to cause errors.... comment it out for now.

            ;   if (keyword_set(plot_is_valid)) then begin
            ;  
            ;     ; if last selected plot was MAP or 2D, change the activation of 1D plots
            ;     if (ptype_struct.xbit ne VARBIT and ptype_struct.ybit ne VARBIT) then begin
            ;       if (ptype_struct.avebit eq pbstruct.avebit) then $            ; make 1D button sensitive
            ;            widget_control, (*self.pbuttons_wid)[ib], sensitive=1 $  ; if average action is the same
            ;       else widget_control, (*self.pbuttons_wid)[ib], sensitive=0    ; otherwise make it unsensitive
            ;     endif else widget_control, (*self.pbuttons_wid)[ib], sensitive=1
            ;
            ;   ; make all compatible 1D plots active
            ;   endif else begin
                 widget_control, (*self.pbuttons_wid)[ib], sensitive=1
            ; 
            ;   endelse
          endelse

        endelse
      endfor
    endif

    ; enable/disable animation
    valid = widget_info(self.animate_wid, /valid_id)
    if (valid) then begin

      ; retrieve plot type
      xtype = self.ptype mod 10  ; coordinate mask on X axis

      ; get variable mask
      index = widget_info(self.pvars_wid,/list_select)  ; listselected index
      pvbits= self.ncfiles->get_pvbits()   ; coordinate bits for plotting variables
      mask = ((*pvbits)[index])[0]        ; first variable selected

      if ( (xtype ne TIMBIT) $  ; plot does not contain time coordinate
           and ((mask and TIMBIT) gt 0) ) then begin ; variable does have time dependence
         widget_control, self.animate_wid, sensitive=1
         widget_control, self.fanimate_wid, sensitive=1
      ENDIF ELSE BEGIN
         widget_control, self.animate_wid, sensitive=0
         widget_control, self.fanimate_wid, sensitive=0
      ENDELSE

   endif

END
