
Function geov_gui::levs_format, levs

    minlv =  min((*levs)[where(*levs gt 0.)])

    if ( minlv ge 0.1 ) then begin
        format='(f10.3)'
    endif else if ( minlv ge 0.01 ) then begin
        format='(f12.4)'
    endif else begin
        format='(E10.4)'
        if( strcmp( !version.os_family , 'windows',3, /fold_case)) then format='(E11.4)'
    endelse

    return, format
End

pro geov_gui::toggel_xtr_cntrls

  widget_control, self.base_wid,  update=0

  widget_control, self.bottom_base, map=self.hide

  if self.hide eq 0 then self.hide = 1 else self.hide = 0

  newsize = self.totsz - self.xtrsz*self.hide

  widget_control, self.base_wid, ysize=newsize ;, xsize=self.tlb_xsz

  if self.hide eq 0 then widget_control, self.xtr_cntrls_button, set_value='Hide Extra Controls' $
  else                   widget_control, self.xtr_cntrls_button, set_value='Show Extra Controls'

  widget_control, self.base_wid, update=1

end




PRO geov_gui::build_gui, mbar=mbar
    @geov_pars
    @nccoord_pars

    ; to prevent flickering or flashing while gui is being built and
    ; repositioned and resized on screen
    widget_control, self.base_wid, map=0, update=0

   self.bar_base = mbar

    ; retrieve coordinate indexes and dimensions

;    xyz = self.ncfiles->get_dsizes()
    xcdims = self.ncfiles->get_cdims()

    csizes = (*(self.ncfiles->get_dsizes()))[*(self.ncfiles->get_cdims())]
    ilat = self.ncfiles->get_ilat()
    ilon = self.ncfiles->get_ilon()
    itim = self.ncfiles->get_itim()
    ilev = self.ncfiles->get_ilev()
;mgs++ (22 April 2002)
    iuvar = self.ncfiles->get_iuvar()
    ivvar = self.ncfiles->get_ivvar()
    iwind = iuvar GE 0 AND ivvar GE 0
;mgs--

    ; FILE menu
    self.file_menu_wid = widget_button(self.bar_base, value='FILE', /menu)
    widget_control, self.file_menu_wid, sensitive=1
    self.open_wid= widget_button(self.file_menu_wid, value='Open...', uvalue=self)
    self.close_wid= widget_button(self.file_menu_wid, value='Close File(s)', uvalue=self)
    self.quit_wid = widget_button(self.file_menu_wid, value='Quit Geov', uvalue=self)
    self.exit_wid = widget_button(self.file_menu_wid, value='Exit IDL', uvalue=self)

    ; DISPLAY menu
    self.display_menu_wid = widget_button(self.bar_base, value='DISPLAY', /menu )
    widget_control, self.display_menu_wid, sensitive=0

    self.unzoom_wid = widget_button(self.display_menu_wid, value='Unzoom', uvalue=self, resource_name='my_droplist')
    self.reset_axes_wid = widget_button(self.display_menu_wid, value='Reset Axes Range', uvalue=self)
    self.contour_wid = widget_button(self.display_menu_wid, value='Set Contour Levels ...', uvalue=self)

    contour_menu = widget_button(self.display_menu_wid, value='Set Contour Type',/menu)
    self.contour_opt_wids[CONTOUR_OPT_LINES_MONO] = widget_button(contour_menu, value='Lines Monochrome', uvalue=self)
    self.contour_opt_wids[CONTOUR_OPT_LINES_COLORED] = widget_button(contour_menu, value='Lines Colored', uvalue=self)
    self.contour_opt_wids[CONTOUR_OPT_FILLED] = widget_button(contour_menu, value='Filled', uvalue=self)
    self.contour_opt_wids[CONTOUR_OPT_LINES_FILLED] = widget_button(contour_menu, value='Lines+Filled', uvalue=self)
    self.contour_opt_wids[CONTOUR_OPT_BOXES] = widget_button(contour_menu, value='Boxes', uvalue=self)

    timeaxis_menu = widget_button(self.display_menu_wid, value='Set Time Axis Type',/menu)
    self.timeaxis_wids[RELATIVE] = widget_button(timeaxis_menu, value='Relative', uvalue=self)
    self.timeaxis_wids[ABSOLUTE] = widget_button(timeaxis_menu, value='Absolute', uvalue=self)

    format_menu = widget_button(self.display_menu_wid, value='Format Scale Labels',/menu)

    for j=0, n_elements(CONLABS_FORMAT_OPTS)-1 do $
        self.set_format_wids[j] = widget_button(format_menu, value=CONLABS_FORMAT_OPTS[j], uvalue=self)

    if (itim ge 0) then begin
     if (csizes[itim] gt 1) then begin
        self.animate_wid = widget_button(self.display_menu_wid, value='Animate', uvalue=self)
        self.fanimate_wid = widget_button(self.display_menu_wid, value='Animate to file', uvalue=self)
     endif
    endif
    colors_menu = widget_button(self.display_menu_wid, value='Colors',/menu)
    self.drawcolors_wid= widget_button(colors_menu, value='Select Drawing Colors ...', uvalue=self)
    self.mycolors_wid = widget_button(colors_menu, value='GEOV colortable', uvalue=self)
    self.idlcolors_wid= widget_button(colors_menu, value='IDL Standard Color Table ...', uvalue=self)
    self.bwrcolors_wid= widget_button(colors_menu, value='Blue-White-Red Color Table', uvalue=self)
    self.titles_wid = widget_button(self.display_menu_wid, value='Edit Plot Titles ...', uvalue=self)
    new_window_menu =  widget_button(self.display_menu_wid, value='Open New Window',/menu)
    self.new_window_wids[0] = widget_button(new_window_menu, value='Small', uvalue=self)
    self.new_window_wids[1] = widget_button(new_window_menu, value='Medium', uvalue=self)
    self.new_window_wids[2] = widget_button(new_window_menu, value='Large', uvalue=self)

    ; PLOT buttons
    self.pbuttons_wid = ptr_new(lonarr(MAX_NUMBER_OF_PLOTS)) ; maximum possible dimension
    self.pbuttons_mask= ptr_new(bytarr(MAX_NUMBER_OF_PLOTS)) ; maximum possible dimension
    self.pbuttons_values= ptr_new(lonarr(MAX_NUMBER_OF_PLOTS)) ; maximum possible dimension
    npbuttons = 0

   ; map plots
    if (ilat ge 0 and ilon ge 0) then begin
     if (csizes[ilat] gt 1 and csizes[ilon] gt 1) then begin

        lats = self.ncfiles->get_lats()
        lons = self.ncfiles->get_lons()

        self.map_menu_wid = widget_button(self.bar_base, value='MAP', /menu)
        widget_control, self.map_menu_wid, sensitive=0

        ; current map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP
        npbuttons = npbuttons + 1

        ; Atlantic map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_AT_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP_AT
        npbuttons = npbuttons + 1

        ; Pacific map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_PA_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP_PA
        npbuttons = npbuttons + 1

        ; North Polar map
        ;indexes = where(lats gt 0, counts)
        ;if (counts gt 0) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_NP_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
          (*self.pbuttons_values)[npbuttons] = MAP_NP
          npbuttons = npbuttons + 1
        ;endif

        ; South Polar map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_SP_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP_SP
        npbuttons = npbuttons + 1

        ; Generic Polar map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_GP_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP_GP
        npbuttons = npbuttons + 1

        ; User Defined map
        (*self.pbuttons_wid)[npbuttons] = widget_button(self.map_menu_wid, value=MAP_USER_TITLE, uvalue=self)
        (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
        (*self.pbuttons_values)[npbuttons] = MAP_USER
        npbuttons = npbuttons + 1

     endif
    endif

    ; 2D plots
    self.plot2d_menu_wid = widget_button(self.bar_base, value='2D PLOT', /menu)
    widget_control, self.plot2d_menu_wid, sensitive=0
    if (ilat ge 0 and ilon ge 0) then begin
     if (csizes[ilat] gt 1 and csizes[ilon] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LATvsLON_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT
      (*self.pbuttons_values)[npbuttons] = LATvsLON
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilat ge 0 and ilon ge 0 and ilev ge 0) then begin
     if (csizes[ilat] gt 1 and csizes[ilon] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LATvsLONpress_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT or LEVBIT
      (*self.pbuttons_values)[npbuttons] = LATvsLONpress
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilev ge 0 and ilat ge 0) then begin
     if (csizes[ilev] gt 1 and csizes[ilat] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LEVvsLAT_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LEVBIT or LATBIT
      (*self.pbuttons_values)[npbuttons] = LEVvsLAT
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilev ge 0 and ilon ge 0) then begin
     if (csizes[ilev] gt 1 and csizes[ilon] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LEVvsLON_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LEVBIT or LONBIT
      (*self.pbuttons_values)[npbuttons] = LEVvsLON
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilev ge 0 and itim ge 0) then begin
        if (csizes[ilev] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LEVvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LEVBIT or TIMBIT
          (*self.pbuttons_values)[npbuttons] = LEVvsTIM
          npbuttons = npbuttons + 1
        endif
    endif
    if (ilat ge 0 and itim ge 0) then begin
        if (csizes[ilat] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LATvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LATBIT or TIMBIT
          (*self.pbuttons_values)[npbuttons] = LATvsTIM
          npbuttons = npbuttons + 1
        endif
    endif
    if (ilon ge 0 and itim ge 0) then begin
        if (csizes[ilon] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LONvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LONBIT or TIMBIT
          (*self.pbuttons_values)[npbuttons] = LONvsTIM
          npbuttons = npbuttons + 1
        endif
    endif

    if (ilon ge 0 and ilev ge 0 and ilat ge 0) then begin
     if (csizes[ilev] gt 1 and csizes[ilon] gt 1 and csizes[ilat] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LONaveLEVvsLAT_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or LEVBIT or LATBIT
      (*self.pbuttons_values)[npbuttons] = LONaveLEVvsLAT
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilev ge 0 and itim ge 0) then begin
        if (csizes[ilev] gt 1 and csizes[itim] gt 1) then begin

        endif
    endif
    if (ilev ge 0 and ilon ge 0 and itim ge 0) then begin
        if (csizes[ilev] gt 1 and csizes[ilon] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LONaveLEVvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LONBIT or TIMBIT or LEVBIT
          (*self.pbuttons_values)[npbuttons] = LONaveLEVvsTIM
          npbuttons = npbuttons + 1
        endif
    endif
    if (ilat ge 0 and ilon ge 0 and itim ge 0) then begin
        if (csizes[ilat] gt 1 and csizes[ilon] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LONaveLATvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LONBIT or TIMBIT or LATBIT
          (*self.pbuttons_values)[npbuttons] = LONaveLATvsTIM
          npbuttons = npbuttons + 1
        endif
    endif

    if (ilat ge 0 and ilev ge 0 and ilon ge 0 and itim ge 0) then begin
        if (csizes[ilev] gt 1 and csizes[ilon] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LATLONaveLEVvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LATBIT or LONBIT or TIMBIT or LEVBIT
          (*self.pbuttons_values)[npbuttons] = LATLONaveLEVvsTIM
          npbuttons = npbuttons + 1
        endif
    endif else if (ilev ge 0 and ilat ge 0 and itim ge 0) then begin
        if (csizes[ilev] gt 1 and csizes[ilat] gt 1 and csizes[itim] gt 1) then begin
          (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot2d_menu_wid, value=LATaveLEVvsTIM_TITLE, uvalue=self)
          (*self.pbuttons_mask)[npbuttons]= LATBIT or TIMBIT or LEVBIT
          (*self.pbuttons_values)[npbuttons] = LATaveLEVvsTIM
          npbuttons = npbuttons + 1
        endif
    endif

    ; 1D PLOT menu
    self.plot1d_menu_wid = widget_button(self.bar_base, value='1D PLOT', /menu)
    widget_control, self.plot1d_menu_wid, sensitive=0
    if (ilat ge 0) then begin
     if (csizes[ilat] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=VARvsLAT_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LATBIT
      (*self.pbuttons_values)[npbuttons] = VARvsLAT
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilon ge 0) then begin
     if (csizes[ilon] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=VARvsLON_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT
      (*self.pbuttons_values)[npbuttons] = VARvsLON
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilev ge 0) then begin
     if (csizes[ilev] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LEVvsVAR_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LEVBIT
      (*self.pbuttons_values)[npbuttons] = LEVvsVAR
      npbuttons = npbuttons + 1
     endif
    endif
    if (itim ge 0) then begin
     if (csizes[itim] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=VARvsTIM_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= TIMBIT
      (*self.pbuttons_values)[npbuttons] = VARvsTIM
      npbuttons = npbuttons + 1
     endif
    endif

    if (ilon ge 0 and ilat ge 0) then begin
     if (csizes[ilon] gt 1 and csizes[ilat] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LONaveVARvsLAT_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or LATBIT
      (*self.pbuttons_values)[npbuttons] = LONaveVARvsLAT
      npbuttons = npbuttons + 1
     endif
    endif
    if (ilon ge 0 and ilev ge 0) then begin
     if (csizes[ilon] gt 1 and csizes[ilev] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LONaveLEVvsVAR_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or LEVBIT
      (*self.pbuttons_values)[npbuttons] = LONaveLEVvsVAR
      npbuttons = npbuttons +  1
     endif
    endif
    if (ilon ge 0 and itim ge 0) then begin
     if (csizes[ilon] gt 1 and csizes[itim] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LONaveVARvsTIM_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or TIMBIT
      (*self.pbuttons_values)[npbuttons] = LONaveVARvsTIM
      npbuttons = npbuttons + 1
     endif
    endif

    if (ilon ge 0 and ilat ge 0 and ilev ge 0) then begin
     if (csizes[ilon] gt 1 and csizes[ilat] gt 1 and csizes[ilev] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LATLONaveLEVvsVAR_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or LATBIT or LEVBIT
      (*self.pbuttons_values)[npbuttons] = LATLONaveLEVvsVAR
      npbuttons = npbuttons + 1
     endif
    endif else if (ilat ge 0 and ilev ge 0) then begin
     if (csizes[ilat] gt 1 and csizes[ilev] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LATaveLEVvsVAR_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LATBIT or LEVBIT
      (*self.pbuttons_values)[npbuttons] = LATaveLEVvsVAR
      npbuttons = npbuttons + 1
     endif
    endif

    if (ilon ge 0 and ilat ge 0 and itim ge 0) then begin
     if (csizes[ilon] gt 1 and csizes[ilat] gt 1 and csizes[itim] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LATLONaveVARvsTIM_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LONBIT or LATBIT or TIMBIT
      (*self.pbuttons_values)[npbuttons] = LATLONaveVARvsTIM
      npbuttons = npbuttons + 1
     endif
    endif else if (ilat ge 0 and itim ge 0) then begin
     if (csizes[ilat] gt 1 and csizes[itim] gt 1) then begin
      (*self.pbuttons_wid)[npbuttons] = widget_button(self.plot1d_menu_wid, value=LATaveVARvsTIM_TITLE, uvalue=self)
      (*self.pbuttons_mask)[npbuttons]= LATBIT or TIMBIT
      (*self.pbuttons_values)[npbuttons] = LATaveVARvsTIM
      npbuttons = npbuttons + 1
     endif
    endif

    ; reduce arrays size
    *self.pbuttons_wid = (*self.pbuttons_wid)[0:npbuttons-1]
    *self.pbuttons_mask= (*self.pbuttons_mask)[0:npbuttons-1]
    *self.pbuttons_values = (*self.pbuttons_values)[0:npbuttons-1]

    ; PRINT menu
    self.print_menu_wid = widget_button(self.bar_base, value='PRINT', /menu)
    widget_control, self.print_menu_wid, sensitive=0
    self.print_types = ['PS','EPS','PNG','JPG','netCDF']


    for i=0,n_elements(self.print_wids)-1 do $
        self.print_wids[i] = widget_button(self.print_menu_wid, value=self.print_types[i], uvalue=self)

    ; Hide/Show Extra Controls
    cntrls_wid = widget_button( self.bar_base, value='CONTROLS', /menu )
    self.xtr_cntrls_button = widget_button( cntrls_wid, value='Hide Extra Controls', uvalue=self )

   ; HELP menu
    self.help_menu_wid = widget_button(self.bar_base, value='HELP', /menu)
    widget_control, self.help_menu_wid, sensitive=1
    self.about_wid= widget_button(self.help_menu_wid, value='About Geov...', uvalue=self)


    ; extract information from netcdf file
    ndims = self.ncfiles->get_ndims()
    dnames= self.ncfiles->get_dnames()
    cvars = self.ncfiles->get_cvars()
    vndims = self.ncfiles->get_vndims()
    vnames= self.ncfiles->get_vnames()

    ;; plot type info
    firstbase = widget_base(self.base_wid, /row)
    ; PLOT TYPE label
    self.ptitle_wid = widget_label(firstbase, value=' ',/align_left,xsize=350)
    self->set_plot, 0

    ; base for species, times, levels lists
    controls_wid = widget_base(self.base_wid,/row)

    ; LIST for plottable variables
    frame_wid = widget_base( controls_wid, /frame, /column, /align_center)
    label_wid = widget_label(frame_wid,value='VARIABLES',/align_center)
    pvars = self.ncfiles->get_pvars()
    pnames = (*vnames)[ (*pvars) ]

    self.pvars_wid = widget_list(frame_wid, value=pnames, ysize=5, /align_center, /multiple, uvalue=self, $
                                 resource_name='my_list' )
    widget_control, self.pvars_wid, set_list_select = 0  ; select first variable in list
    widget_control, self.pvars_wid, sensitive=1

    ; LIST widget for latitudes
    lats = self.ncfiles->get_lats()
    if (ptr_valid(lats)) then begin
        frame_wid = widget_base(controls_wid,/frame,/column)
        label_wid = widget_label(frame_wid,value='LATITUDE',/align_center)
        lnames = string(*lats,format='(G7.4)')
        self.lats_wid = widget_list(frame_wid, value=lnames, ysize=5, /align_center, /multiple, uvalue=self, $
                                    resource_name='my_list')
        widget_control, self.lats_wid, set_list_select = 0  ; select first latitude
        widget_control, self.lats_wid, sensitive=0
    endif

    ; LIST widget for longitudes
    lons = self.ncfiles->get_lons()
    if (ptr_valid(lons)) then begin
        frame_wid = widget_base(controls_wid,/frame,/column)
        label_wid = widget_label(frame_wid,value='LONGITUDE',/align_center)
        lnames = string(*lons,format='(G7.4)')
        self.lons_wid = widget_list(frame_wid, value=lnames, ysize=5, /align_center, /multiple, uvalue=self, $
                                    resource_name='my_list')
        widget_control, self.lons_wid, set_list_select = 0  ; select first latitude
        widget_control, self.lons_wid, sensitive=0
    endif

    ; LIST widget for levels
    levs = self.ncfiles->get_levs()

    if (ptr_valid(levs)) then BEGIN
       if (self.ncfiles->is_cflag_set(ilev,NCCOORD_FLAG_PRESSURE)) THEN BEGIN
          maxlev = max(*levs, imaxlev)
       ENDIF ELSE imaxlev = 0
        frame_wid = widget_base(controls_wid,/frame,/column)
        label_wid = widget_label(frame_wid,value='LEVELS',/align_center)

        lnames = strtrim(string(*levs,format=self->levs_format(levs)),2)

        self.levs_wid = widget_list(frame_wid, value=lnames, ysize=5, /multiple, /align_center, uvalue=self, $
                                    resource_name='my_list')
;;      widget_control, self.levs_wid, set_list_select = 0  ; select first level
        widget_control, self.levs_wid, set_list_select = imaxlev  ; select last level
        widget_control, self.levs_wid, sensitive=0
    endif

   ; LIST widget for times
;    times = self.ncfiles->get_times()

    stamps =  self.ncfiles->get_timestamps()

;    if (ptr_valid(times)) then begin
    if (n_elements(stamps) gt 0) then begin
     if (strlen(stamps[0]) gt 0) then begin
;      if (  n_elements(*times) gt 0 ) then begin
        frame_wid = widget_base(controls_wid,/frame,/column)
        label_wid = widget_label(frame_wid,value='TIME',/align_center)
        ; convert times to labels according to model-specific rules
;        tnames = strarr(n_elements(*times))
;        for i=0,n_elements(tnames)-1 DO BEGIN
;          tnames[i] = self.ncfiles->get_timestamp((*times)[i])
;        ENDFOR
;        self.times_wid = widget_list(frame_wid, value=tnames, ysize=5, /align_center, /multiple,  uvalue=self, $
;                                     resource_name='my_list')
        self.times_wid = widget_list(frame_wid, value=stamps, ysize=5, /align_center, /multiple,  uvalue=self, $
                                     resource_name='my_list')
        widget_control, self.times_wid, set_list_select = 0  ; select first time
        widget_control, self.times_wid, sensitive=0
;      endif
      endif
    endif

    options_wid = widget_base(controls_wid,/column)


;    right_base = widget_base(controls_wid,/column)

    ; bottom bar
    self.bottom_base = widget_base(self.base_wid, /row )

    tmp_base = widget_base(self.bottom_base, column=1, frame=2 )
    label = widget_label(tmp_base,value='Display Options:')

    auto_base = widget_base( tmp_base, column=1 , frame=1 )

    ; AUTO CONTOUR button
    self.auto_contour_wid = cw_bgroup(auto_base, /row, uvalue=self, $
                                 ['Automatic Contour Levels'], $
;;                                 /no_release, $ ; do not generate release events
                                 /nonexclusive )
    widget_control, self.auto_contour_wid, set_value=1
    widget_control, self.auto_contour_wid, sensitive=0

    ; Auto-Log/Linear option
    self.auto_log_linear_wid = cw_bgroup( auto_base, uvalue=self, ['auto', 'log','linear'],$
                                          /exclusive, row=1,set_value=0 ,/no_release)
    widget_control, self.auto_log_linear_wid, sensitive=0

    ; log-p option
    if (ilev ge 0) then begin
      if (self.ncfiles->is_cflag_set(ilev,NCCOORD_FLAG_PRESSURE) or $
        self.ncfiles->is_cflag_set(ilev,NCCOORD_FLAG_KM) ) then begin
        if (self.ncfiles->is_cflag_set(ilev,NCCOORD_FLAG_PRESSURE)) then value=0 else value=1
        self.logp_wid = cw_bgroup(tmp_base, uvalue=self, ['Level altitudes'], $
                                  /nonexclusive, set_value=value, ids=ids)
        widget_control, self.logp_wid, sensitive=0
      endif
    endif

    ; same-scale switch for over plots
    self.samescale_wid =  cw_bgroup(tmp_base, uvalue=self, ['Oplot Same Scale'], $
                                  /nonexclusive, set_value=0)
    widget_control, self.samescale_wid, sensitive=0

    ; wind vector option
    if (iwind) then BEGIN
      value = 0 ; default to off state
      self.uvwind_wid = cw_bgroup(tmp_base, uvalue=self, ['Wind Vectors'], $
                                 /nonexclusive, set_value=value)
      widget_control, self.uvwind_wid, sensitive=0
    endif

    ; scaling wid (mgs: made this a group of exclusive buttons)
;;     self.scaling_wid = cw_bgroup(bottom_base, uvalue=self, ['Scale VMR data to ppm, ppb, ppt'], $
;;                                 /nonexclusive)
    tmp_base = widget_base(self.bottom_base, column=1, frame=2)
    label = widget_label(tmp_base,value='Scale VMR data:')
    self.scaling_wid = cw_bgroup(tmp_base, uvalue=self, $
                                 ["don't scale", "ppm", "ppb", "ppt"], $ ;; ###  , "molec./cm^3"], $
                                 /exclusive, column=1, set_value=0, /no_release)
    widget_control, self.scaling_wid, sensitive=0

    ; OPERATOR selection
    tmp0_base = widget_base(self.bottom_base, column=1)
    tmp_base = widget_base(tmp0_base, column=2, /frame)

    ops_base = widget_base(tmp_base, column=1 )
    xtr_base = widget_base(tmp_base, column=1 ) 

    label = widget_label(xtr_base,value='Extractor:')
    label = widget_label(ops_base,value='Operator:')

    self.operator_wid = widget_droplist(ops_base, value=operator_names,uvalue=self)
    self.extractor_wid = widget_droplist(xtr_base, value=extractor_names,uvalue=self)

    widget_control, self.extractor_wid, sensitive=0
    widget_control, self.operator_wid, sensitive=0

    self.overplot_wid = widget_button(ops_base, value='Overplot', uvalue=self)
    widget_control, self.overplot_wid, sensitive=0

;    self.overplot_wid =  cw_bgroup(ops_base, uvalue=self, ['Overplot'],/nonexclusive, set_value=0)

;    self.operator_wid = widget_droplist(tmp_base,value=operator_names,uvalue=self)
;    widget_control, self.operator_wid, sensitive=0

    ; ANIMATION
;; mgs 20 April 2002: bug fix - IDL doesn't allow shortcut in IF
    if (itim ge 0) THEN BEGIN
       if (csizes[itim] gt 1) then begin
          tmp_base = widget_base(tmp0_base, /row, /frame)
          label = widget_label(tmp_base,value='ANIMATION: step=')
          self.astep_wid = widget_text(tmp_base, value='1',/editable,xsize=3,uvalue=self)
          label = widget_label(tmp_base,value='start=')
          self.astart_wid = widget_text(tmp_base, value='0',/editable,xsize=3,uvalue=self)
       ENDIF
    endif

    ; add synchronize button or switch...
    ;tmp_base = widget_base(tmp0_base, /row, /frame)
    ;sync_wid = widget_button(tmp_base, value='Synchronize Scales')

END
