PRO geov_gui::CLEANUP
    @geov_pars

    ; make sure that associated netCDF file set gets destroyed in the process
    obj_destroy, self.ncfiles

    ; destroy all associated plotters
    for ip=0, n_elements(self.plotters)-1 do begin
        if (obj_valid(self.plotters[ip])) then obj_destroy, self.plotters[ip]
    endfor

    ; free other memory
    ptr_free, self.pbuttons_wid
    ptr_free, self.pbuttons_mask
    ptr_free, self.pbuttons_values
    if (ptr_valid(self.mydrawcolors)) then ptr_free, self.mydrawcolors
    if (ptr_valid(self.const_press)) then ptr_free, self.const_press
    for i=0, n_elements(*self.edges)-1 do begin
        if (ptr_valid((*self.edges)[i])) then ptr_free, (*self.edges)[i]
    endfor
    ptr_free, self.edges

    if ptr_valid( self.summed_flds ) then ptr_free, self.summed_flds

    ; superclass destructor
    self->gui::CLEANUP

    HEAP_GC

END
