FUNCTION geov_manager::get_preferences
  return, self.preferences
END

Function geov_manager::get_operand_title, plotter_ref
  @geov_pars

  title=''

  indices = where( self.operands eq plotter_ref )

  index = (where( self.operands eq plotter_ref ))[0]

  if (index ge 0) then begin
    title = self.operandlabels[index]
    return, title
  endif

  for i = 0, MAXSCREENS-1 do begin
    if ( not obj_valid( self.operands[i] ) ) then begin
      self.operands[i] = plotter_ref
      title = self.operandlabels[i]
      return, title
    endif
  endfor

  return, title
End

Function geov_manager::get_data_from_operand_label, label

  plotter_ref = obj_new()
  data = ptr_new()

  for i = 0, MAXSCREENS-1 do begin
    if ( label eq self.operandlabels[i] ) then begin
      plotter_ref = self.operands[i]
      if ( obj_valid(plotter_ref) ) then begin
        data = plotter_ref->get_data()
        return, data
      endif
    endif
  endfor

  return, data
End

Function geov_manager::get_plot_data, plotter_ref

  index = (where( self.operands eq plotter_ref ))[0]
  if index lt 0 then return, ptr_new()
  return, self.operands[index]->get_data()

end

Function geov_manager::get_oplot_coords,plotter_ref
  ii = where( obj_valid(self.operands),n )
  if n eq 0 then return, [ptr_new(),ptr_new()]

  index = (where( self.operands[ii] ne plotter_ref ))[0]
  if index lt 0 then return, [ptr_new(),ptr_new()]
  coords = [ptr_new(*(self.operands[index]->get_xs())),ptr_new(*(self.operands[index]->get_ys()))]
  return, coords
end

Function geov_manager::get_oplot_data,plotter_ref

  ii = where( obj_valid(self.operands),n )
  if n eq 0 then return, ptr_new()

  index = (where( self.operands[ii] ne plotter_ref ))[0]
  if index lt 0 then return, ptr_new()
  data = ptr_new(*(self.operands[index]->get_data()))
  return, data

end

Function geov_manager::get_operand_data, xs_ptrs=xs_ptrs, ys_ptrs=ys_ptrs
  @geov_pars
  dataptrs = ptrarr(MAXSCREENS)
  xs_ptrs = ptrarr(MAXSCREENS)
  ys_ptrs = ptrarr(MAXSCREENS)

  for i = 0, MAXSCREENS-1 do begin
    if ( obj_valid( self.operands[i] ) ) then begin
      dataptrs[i] = (self.operands[i])->get_displayeddata(xs=xs,ys=ys)
      xs_ptrs[i] = xs
      ys_ptrs[i] = ys
    endif
  endfor


  return, dataptrs
END

Function geov_manager::get_operand_labels
  return, self.operandlabels
END

Function geov_manager::get_number_of_plotters
  @geov_pars
  n = 0
  for i = 0, MAXSCREENS-1 do begin
    if ( obj_valid( self.operands[i] ) ) then n=n+1
  endfor

  return,n
END

PRO geov_manager::get
END
