; synchronize all the currently active plotters
; i.e., set corresponding axis ranges equal for all plotters
Pro geov_manager::sync_scales
  iguis = where( obj_valid(self.guis) )
  if (iguis[0] eq -1) then return

  plttr = self.guis[iguis[0]]->get_plotter()
  xrs = plttr->get_xyzrange(0)
  yrs = plttr->get_xyzrange(1)
  zrs = plttr->get_xyzrange(2)

  for i=1,n_elements(iguis)-1 do begin
    plttr = self.guis[iguis[i]]->get_plotter()
    xrs = [xrs,plttr->get_xyzrange(0)]
    yrs = [yrs,plttr->get_xyzrange(1)]
    zrs = [zrs,plttr->get_xyzrange(2)]
  endfor
  
  for i=0,n_elements(iguis)-1 do begin
    plttr = self.guis[iguis[i]]->get_plotter()
    plttr->set_xyzrange, [min(xrs),max(xrs)], 0
    plttr->set_xyzrange, [min(yrs),max(yrs)], 1
    plttr->set_xyzrange, [min(zrs),max(zrs)], 2
    plttr->plot
  endfor

End

PRO geov_manager::set
END
