FUNCTION geov_ncfile::init, ncfilename
  @geov_pars

  ; precompile access functions
  self->geov_ncfile::get

  ; explicit call to superclass constructor --> calls find_coord()
  ok = self->nccoordfile::init(ncfilename)

  ; find u and v wind components if available (mgs 22 April 2002)
  self->find_uv

  ; for each plottable variable, store coordinate dependence as bits
  self.pvbits= ptr_new(bytarr(self.npvars))
  for iv=0, self.npvars-1 do begin

      vid = (*self.pvars)[iv]   ; variable id in file
      vndim=(*self.vndims)[vid]


      for idim=0,vndim-1 do begin ; loop over dimensions for this variable
          did = self->get_dimid_of_var(idim,vid)

          indexes = where(*self.cdims eq did, counts) ; check it's a coordinate

          if (counts gt 0) then begin

              ic = (*self.d2coord)[did]


              if ic ge 0 then begin
                  dsize = (*self.dsizes)[(*self.cdims)[ic]]
              endif else begin
                  NCDF_DIMINQ, self.fid, did, name, dsize
              endelse

              ;if ( dsize gt 1 ) then begin
                CASE ic OF
                   self.ilat: if ( dsize gt 1 ) then (*self.pvbits)[iv] = (*self.pvbits)[iv] OR LATBIT
                   self.ilon: if ( dsize gt 1 ) then (*self.pvbits)[iv] = (*self.pvbits)[iv] OR LONBIT
                   self.ilev: if ( dsize gt 1 ) then (*self.pvbits)[iv] = (*self.pvbits)[iv] OR LEVBIT
                   self.ilevi:if ( dsize gt 1 ) then (*self.pvbits)[iv] = (*self.pvbits)[iv] OR LEVBIT
                   self.itim: (*self.pvbits)[iv] = (*self.pvbits)[iv] OR TIMBIT
                   ELSE : ; print,'### CASE error in geov_ncfile::init !'
                ENDCASE
              ;endif
          endif
      endfor

  endfor

  ; model customization
  if (ok) then self->custom

  tmppref = Obj_New('geov_preferences')
  date_format = tmppref->get_dateformat()
  calendar = tmppref->get_default_calendar()
  Obj_Destroy, tmppref
  self.times = obj_new('nctime',self.fid,calendar=calendar,date_format=date_format)
  
  return, ok

END
