PRO geov_plotter::event_listener, event
  @geov_pars

  ; determine which event type
  event_name = strlowcase(tag_names(event, /structure_name))

  CASE event_name OF

       ; FOCUS events generated by widget_base:
       ; notify all registered users
       'widget_kbrd_focus': if (event.enter eq 1) then begin
                                ; move current gui to the foreground
                                (self->get_gui())->focus
                                ; move itself on top and select the associated graphic window
                                self->focus
                                ; set as current with current gui and with manager
                                self.manager->set_plotter, self
                                (self->get_gui())->set_plotter, self
                                ; loop over all registered guis and update controls
                                for ig=0, n_elements(self.guis)-1 do begin
                                    if (obj_valid(self.guis[ig])) then begin
                                       ; check plotter has not been just created
                                       if (self.ptype ne 0) then begin
                                         ; always update current gui, and update all others if last operation was binary
                                         if ( (self.guis[ig] eq self->get_gui()) $
                                             or (self->is_binary(self.operator)) ) then begin
                                             (self.guis[ig])->import_all ; update gui selection
                                             (self.guis[ig])->activator, /lists, /plot_buttons  ; activate controls accordingly
                                         endif
                                       endif
                                    endif
                                endfor
                            endif

;mgs++
       ; RESIZE events generated by widget_base:
       'widget_base': BEGIN
          ;; swallow following events to avoid slow redraws
          eventname = tag_names(event, /structure_name)
          ; get size of status bar (leave height untouched)
          stg = Widget_Info(self.status_bar_wid, /Geometry)
          Widget_Control, self.draw_wid, Scr_XSize = event.x, Scr_Ysize = (event.y-stg.scr_ysize)
          Widget_Control, self.status_bar_wid, Scr_XSize = event.x
;; help,event,/stru

          self->Plot, /noinit
       END

;mgs--

       ; MOUSE event generated by widget_draw
       ; (require drawing screen not to be empty)
       'widget_draw': if (ptr_valid(self.xs) and ptr_valid(self.ys)) then self.zoomer->mouse_event_listener, event

  ENDCASE

END
