
; method to instantiate extractors for requested plot
FUNCTION geov_plotter::extractors
 @geov_pars

    ; destroy previous extractors
    for ix=0, n_elements(self.extractors)-1 do begin
        if (obj_valid(self.extractors[ix])) then begin
          obj_destroy, self.extractors[ix]
        endif
    endfor

    ; instantiate extractor for current gui
    gui = self->get_gui()
    ncfiles = gui->get_ncfiles()
    self.extractors[self.igui] = obj_new('geov_extractor', gui, ncfiles )


    ; possibly instantiate another extractor
    op = gui->get_operator()
    ;if ((self->is_binary(op) eq 1) or (op eq OP_USR_DEF)) then begin
    if (self->is_binary(op) eq 1)  then begin

        ; flag other extractor
        if (self.igui eq 0) then iother = 1 else iother = 0

        ; check if double selection from current gui
        lats = gui->get_lat()
        lons = gui->get_lon()
        levs = gui->get_lev()
        times= gui->get_time()
        ipvars = gui->get_ipvar()

        ; double selection --> use same gui, ncfiles
        if ((n_elements(lons) eq 2) or (n_elements(lats) eq 2) or (n_elements(levs) eq 2) or $
            (n_elements(times) eq 2) or (n_elements(ipvars) eq 2) ) then begin
             self.extractors[iother] = obj_new('geov_extractor', gui, ncfiles )

        ; single selection --> use other gui, ncfiles
        endif else begin

             gui = self.guis[iother] ; get other registered gui
             ;if ((op eq OP_USR_DEF) and (not obj_valid(gui))) then return, 0
             if (not obj_valid(gui)) then begin
                 print,'WARNING: BINARY OPERATOR REQUESTED, BUT ONLY ONE DATASET SPECIFIED'
                 return, 1 ; error
             endif
             ncfiles = gui->get_ncfiles()
             self.extractors[iother] = obj_new('geov_extractor', gui, ncfiles )

       endelse
    endif

    return, 0

END
