PRO geov_zoomer::mouse_press_release_event, event

    @geov_pars

    ; undraw previous box
    if (self.is_showing gt 0) then plots, self.box_xs, self.box_ys, col=self.color, /dev, thick=1, lines=0
    self.is_showing = 0 
                               
    ; check click was within plot bounds
    if (self->check_bounds(event.x, event.y) eq 1) then begin

        ; draw box around selected point
;        width = !d.x_size/40.
;        height= !d.y_size/40.
;        xlow = event.x-0.5*width
;        xhig = event.x+0.5*width
;        ylow = event.y-0.5*height
;        yhig = event.y+0.5*height
;        self.box_xs = [xlow, xhig, xhig, xlow, xlow]
;        self.box_ys = [yhig, yhig, ylow, ylow, yhig]
;
; Sometimes this box does not get undrawn for some unkown reseason.
; For now we just don't draw the box.
;
;        plots, self.box_xs, self.box_ys, /dev, color=self.color, thick=1, lines=0
;        self.is_showing = 1 ; mouse clicked on this plot before

        event_coords = convert_coord( event.x, event.y, /device, /to_data )
        ; fix longitude
        icx = self.plotter->get_xcoord_index()
        icy = self.plotter->get_ycoord_index()
        if (icx eq MYLON) then event_coords[0] = self->convert_lon(event_coords[0],/to_data)
        if (icy eq MYLON) then event_coords[1] = self->convert_lon(event_coords[1],/to_data)
        self.plotter->set_point, event_coords

    endif

    ; reset the original graphic function
    device, set_graphics_function = self.gf

    ; disable motion event
    widget_control, self.plotter->get_draw_wid(), draw_motion_events=0

end


PRO geov_zoomer::mouse_event_listener, event
    @geov_pars

    ; MOUSE-PRESSED event
    if (event.type eq 0) then begin

       self.mouse_status = 1

       ; store coordinates where mouse was pressed
       self.xPress = event.x
       self.yPress = event.y

       ; change the graphic function
       device, get_graphics_function = gf & self.gf = gf
       device, set_graphics_function = 10 ; graphic function set to insert pixels of screen

       ; set mode according to plotter current plot type
       ptype = self.plotter->get_ptype()
       if (ptype eq MAP_NP or ptype eq MAP_SP or ptype eq MAP_GP) then $
            self.mode = self.MODE_CIRCLE $
       else self.mode = self.MODE_BOX

       ; set map flag
       if ((geov_get_bit_struct(ptype)).mapbit gt 0) then self.ismap=1 else self.ismap=0

       ; retrieve circle center
       if (self.mode eq self.MODE_CIRCLE) then $
           self.center = (convert_coord(self.map_center[1,self.izoom], $
                                        self.map_center[0,self.izoom], /data,/to_device))[0:1]

       ; enable motion event
       widget_control, self.plotter->get_draw_wid(), draw_motion_events=1

    ; MOUSE MOVED event
    endif else if (event.type eq 2) then begin

       self.mouse_status = 2

       ; work with circles
       if (self.mode eq self.MODE_CIRCLE) then begin
           ; undraw previous circle
           if (self.is_showing gt 0) then  plots, self.circle, /dev, thick=1, lines=0
           ; circle radius
           radius = sqrt( (self.center[0]-event.x)^2 + (self.center[1]-event.y)^2 )
           ; draw circle
           self.circle = circle(self.center[0], self.center[1], radius)
           plots, self.circle, /dev, thick=1, lines=0

       ; work with boxes
       endif else begin
          ; undraw previous box
          if (self.is_showing gt 0) then plots, self.box_xs, self.box_ys, col=self.color, /dev, thick=1, lines=0
          ; draw new box
          self.box_xs = [self.xPress, event.x, event.x, self.xPress, self.xPress]
          self.box_ys = [self.yPress, self.yPress, event.y, event.y, self.yPress]
          plots, self.box_xs, self.box_ys, col=self.color, /dev, thick=1, lines=0 
       endelse

       self.is_showing = 1


    ; MOUSE RELEASE EVENT
    endif else if (event.type eq 1) then begin

       ; press-release event (no motion)
       if (self.mouse_status ne 2) then begin

         self->mouse_press_release_event, event
         ; reset mouse status
         self.mouse_status = 0       ; end of mouse event


       ; end of a mouse-motion event
       endif else begin

           ; undraw box/circle
           if (self.mode eq self.MODE_CIRCLE) then begin
               if (self.is_showing gt 0) then  plots, self.circle, /dev, thick=1, lines=0
           endif else begin
               if (self.is_showing gt 0) then plots, self.box_xs, self.box_ys, col=self.color, /dev, thick=1, lines=0
           endelse

           ; reset the original graphic function
           device, set_graphics_function = self.gf

           ; reset mouse status
           self.is_showing = 0 ; never clicked on this plot
           self.mouse_status = 0  ; end of mouse event

           ; disable motion events
           widget_control, self.plotter->get_draw_wid(), draw_motion_events=0

           ; reduce point to within box limits
           ;print,'points=',self.xPress,self.yPress,event.x,event.y
           xPress  = self->correct_xbounds(self.xPress)
           yPress  = self->correct_ybounds(self.yPress)
           event_x = self->correct_xbounds(event.x)
           event_y = self->correct_ybounds(event.y)
           ;print,'after correction',xPress,yPress,event_x,event_y 

           ; zoom in
           if (self.mode eq self.MODE_CIRCLE) then begin
               ; circle radius
               radius = sqrt( (self.center[0]-event.x)^2 + (self.center[1]-event.y)^2 )
               ; transform to IDL data coordinates
               west_point  = convert_coord(self.center[0]-radius,self.center[1],/device,/to_data)
               north_point = convert_coord(self.center[0],self.center[1]+radius,/device,/to_data)
               east_point  = convert_coord(self.center[0]+radius,self.center[1],/device,/to_data)
               south_point = convert_coord(self.center[0],self.center[1]-radius,/device,/to_data)
               error = self->zoom_circle(west_point, north_point, east_point, south_point)
               if (error eq 0) then self.plotter->plot

           endif else begin
              ; select lower left point, upper right point and center point of zooming region
              llp = [min([xPress,event_x]),min([yPress,event_y])]
              urp = [max([xPress,event_x]),max([yPress,event_y])]
              cp  = [0.5*(llp[0]+urp[0]),0.5*(llp[1]+urp[1])]
              ; transform to IDL data coordinates
              lower_left_point = convert_coord(llp[0],llp[1],/device,/to_data)
              upper_right_point= convert_coord(urp[0],urp[1],/device,/to_data)
              center_point     = convert_coord(cp[0],cp[1],  /device,/to_data)
              error = self->zoom_box(lower_left_point, center_point, upper_right_point)
              if (error eq 0) then self.plotter->plot, success=success

              if (success eq 0) then begin

                 ; treat as mouse press & release event
                 self->mouse_press_release_event, event 

              endif

           endelse

       endelse

    endif 

END
