; method to setup mapping parameters for zoom=0 
; NOTE: use keywords according to desired functionality
; keyword map_type: MAP_AT, MAP_PA, MAP_NP, MAP_SP, MAP_GP (in which case map_center must be specified)
; keyword map_system: -1 for longitude range [-180, 180] (default), 1 for longitude range [0,360]
PRO geov_zoomer::setup_map, map_limits=map_limits, map_center=map_center,     $
                            map_type=map_type, map_system=map_system
  @geov_pars
  @map_pars

  ; unzoom to step=0
  self->unzoom, /full

  ; case 1: specify map_limits and map_center --> determine map_system from map_limits
  if (keyword_set(map_limits) and keyword_set(map_center)) then begin
      self.map_limits[*,0] = map_limits
      self.map_center[*,0] = map_center

  ; case 2: specify map_type and optionally map_system, map_center
  endif else if (keyword_set(map_type)) then begin

    if (keyword_set(map_system)) then map_system = map_system else map_system = MAP_SYSTEM_NEGATIVE ; default map system

    CASE map_type OF

         MAP_AT: BEGIN
                   self.map_limits[*,0] = [-90, -180, 90, 180]
                   self.map_center[*,0] = [0, 0]
                 END
         MAP_PA: BEGIN
                   self.map_limits[*,0] = [-90, 0, 90, 360]
                   self.map_center[*,0] = [0, 180]
                 END
         MAP_NP: BEGIN
                   if (map_system eq  MAP_SYSTEM_POSITIVE) then self.map_limits[*,0] = [-90, 0, 90, 360] $
                   else                                         self.map_limits[*,0] = [-90, -180, 90, 180]
                   self.map_center[*,0] = [90, 0]
                 END
         MAP_SP: BEGIN
                   if (map_system eq  MAP_SYSTEM_POSITIVE) then self.map_limits[*,0] = [-90, 0, 90, 360] $
                   else                                         self.map_limits[*,0] = [-90, -180, 90, 180]
                   self.map_center[*,0] = [-90, 0]
                 END
         MAP_GP: BEGIN
                   if (map_system eq  MAP_SYSTEM_POSITIVE) then self.map_limits[*,0] = [-90, 0, 90, 360] $
                   else                                    self.map_limits[*,0] = [-90, -180, 90, 180]
                   if (keyword_set(map_center)) then self.map_center[*,0] = map_center
                 END

    ENDCASE

  endif

END
