; method to define lat/lon grid
PRO hank_ncfile::grid, latmin, latmax, latdel, lonmin, lonmax, londel

     ; define latitude/longitude grid
     self.lats = ptr_new(latmin + latdel*findgen(1+(latmax-latmin)/latdel))
     self.lons = ptr_new(lonmin + londel*findgen(1+(lonmax-lonmin)/londel))
     self.xs = ptr_new(fltarr(n_elements(*self.lons), n_elements(*self.lats)))
     self.ys = ptr_new(fltarr(n_elements(*self.lons), n_elements(*self.lats)))

     for ilon=0,n_elements(*self.lons)-1 do begin
       for ilat=0,n_elements(*self.lats)-1 do begin

            xy = self->get_xy((*self.lats)[ilat],(*self.lons)[ilon])

            (*self.xs)[ilon,ilat] = xy[0]
            (*self.ys)[ilon,ilat] = xy[1]

        endfor
     endfor

     ; find x,y for center of map
     xy = self->get_xy(self.lat0, self.lon0)
     x0 = xy[0]
     y0 = xy[1]

     ; convert x,y --> indexes i,j
     ; determine central index
     i0 = fix(((*self.dsizes)[self.ix]-1)/2)
     j0 = fix(((*self.dsizes)[self.iy]-1)/2)
     ; map (x,y) --> (i,j) to use in interpolation
     self.is = ptr_new( (*self.xs-x0)/self.dx + i0 )
     self.js = ptr_new( (*self.ys-y0)/self.dy + j0 )

END
