pro operator_userdef_event, event

  widget_control, event.top,get_uvalue=pState
  widget_control, event.id, get_value=val

  case strupcase( val[0] ) of

    'ACCEPT':  begin
                 widget_control,(*pState).expression, get_value=expr
                 (*pState).out.expr = string( expr[0] )
                 (*pState).out.cancel = 0
                 widget_control,event.top,/destroy
               end

    'CANCEL':  widget_control,event.top,/destroy

    ELSE:

  endcase

end

; method to use the user-defined function
; data missing values must be substituted with !values.f_nan before calling this method
FUNCTION operator_userdef, data, labels, expression=expression,group_leader=group_leader, $
                           xs_ptrs=xs_ptrs, ys_ptrs=ys_ptrs, plotter=plotter, interpolate=interpolate


  valid_indices = where( ptr_valid(data))
  if ( valid_indices[0] lt 0 ) then return, ptr_new()
  valid_data = data[valid_indices]

  ; check array dimensions match
  for k=1,n_elements(valid_data)-1 do begin

    size1 = size(*(valid_data[k]),/dimensions)
    size2 = size(*(valid_data[k-1]),/dimensions)


    if( not array_equal(size1,size2) ) then begin ; equal=0

      if keyword_set(interpolate) then begin 
          plotter->interpolate_data, valid_data[0], valid_data[k], xs_ptrs[0], ys_ptrs[0], xs_ptrs[k], ys_ptrs[k]
        
      endif else xx=dialog_message('Sizes of some of the data arrays are not equal'$
                                           ,title="WARNING",/information)

   endif

  endfor ; k-loop

  tbl = widget_base( /col, title='User-defined function entry', tlb_frame_attr=1,$
                     /modal,group_leader=group_leader )

  ;thisFont = "Comic Sans MS*16*Bold"
  if ( STRCMP(!VERSION.OS_FAMILY , 'win', 3,/fold_case) ) then thisFont = 'Courier*16*Bold'
  if ( STRCMP(!VERSION.OS_FAMILY , 'unix',4,/fold_case) ) then thisFont = '10x16bold'
  
  expression = cw_field( tbl, title='e.g. p + 2*q', /col, $
                         xsize=50, ysize=1, fieldfont=thisFont, font=thisFont)

  rowBase = widget_base(tbl,/row)
  acceptid= widget_button(rowBase, value='Accept')
  cancelid= widget_button(rowBase, value='Cancel')

  widget_control, tbl, default_button=acceptid,  cancel_button=cancelid

  widget_control, tbl, /realize

  out={expr:'',cancel:1}
  state={out:out,expression:expression}
  pState=ptr_new(state,/no_copy)
  widget_control,tbl,set_uvalue=pState

  xmanager,'operator_userdef',tbl

  stateInfo = *pState
  ptr_free, pState

  if ( stateInfo.out.cancel ) then return, ptr_new() ; return null ptr

  for i=0, n_elements(valid_indices)-1 do begin
      ex = labels[valid_indices[i]] +' = *(data[' + string(valid_indices[i]) + '])'
      res = execute( ex, 0)
  endfor

  expr = 'yout = '+ strtrim( stateInfo.out.expr )
  result=execute( expr, 0 )
  if ( keyword_set(expression) ) then expression = strtrim( stateInfo.out.expr )

  if (result eq 0) then begin
    xx=dialog_message('Illegal expression',dialog_parent=group_leader ,/error)
    return, ptr_new()
  endif


  return, ptr_new(yout)
END

