; -------------------------------------------------------------------------;
; GEOV: IDL-based viewer for geophysical data in netCDF format            
; see file igeov.pro for version and licensing info
; Debugging version : exclude the geov directory from the IDL search
; path to force execution of the local copy.
; (mgs, 15 Aug 2002)
; -------------------------------------------------------------------------;

!QUIET=1   ;; suppress informational messages

; exclude geov directory from IDL search path
s=StrSplit(!PATH,':',/extract)
w=where(StrPos(s,'geov') LT 0, cnt)
IF cnt GT 0 THEN s=s[w]
!PATH=StrJoin(s,':')

; call actual initialisation procedure
; (needs to be a procedure in order to find out the directory where
; geov resides)
print
print,'   +++++++++    Starting local copy of geov!     +++++++++'
igeov

