; method to load one of my predefined color tables
PRO color_manager::loadmyct, myt
  @geov_pars

  if (!d.n_colors gt 256 and strlowcase(!d.name) ne 'ps') then device,decompose=0

  CASE myt OF

    ;COLOR_TABLE_RED_TEMPERATURES: tobeloaded = [self.dark_gray, self.light_magenta, self.magenta,    self.dark_magenta, self.dark_blue, $
    ;                                            self.blue,      self.cyan,          self.dark_green, self.green,        self.lime,      $
    ;                                            self.yellow,    self.orange,        self.pink,       self.red_magenta,  self.red        ]

    COLOR_TABLE_RED_TEMPERATURES: tobeloaded = [self.light_gray, self.light_violet, self.violet, self.dark_violet, $
                                                self.blue_magenta, self.blue, self.blue_cyan, self.cyan,           $
                                                self.green_cyan, self.green, self.pea, self.yellow,                $
                                                self.mandarin, self.light_reddish, self.dark_reddish, self.red     ]

  ELSE: BEGIN
         print,'UNRECOGNIZED COLOR TABLE'
         return
        END

  ENDCASE

;****** NOTE *****
; this does not seem to account for the 'reserved' colors that are
; used to draw axis, labels, etc.

  color_matrix = bytarr(!d.table_size,3)
  color_matrix[0,0:2] = (*self.mycolors)[self.black,0:2] ; always load black in 0 position
  ncolors = n_elements(tobeloaded)
  delta = round(float((!d.table_size-2))/float(ncolors-1))
  istart=1
  for ic=0, ncolors-2 do begin
      istop = min([(ic+1)*delta,!d.table_size-2])
      for i=istart,istop do begin
      ;   color_matrix[i,0:2] = (*self.mycolors)[tobeloaded[ic],0:2]
         ; make the color table continuously change by interpolating
         ; so that no two contour levels have the same color
         f2 = float(i - istart)/float(istop - istart)
         f1 = float(istop - i )/float(istop - istart)
         color_matrix[i,0:2] = f1*(*self.mycolors)[tobeloaded[ic],0:2] + f2*(*self.mycolors)[tobeloaded[ic+1],0:2]
      endfor
      istart=istop+1
  endfor
  for i=istart,!d.table_size-1 do color_matrix[i,0:2] = (*self.mycolors)[self.white,0:2] ; fill remaining positions with white

  tvlct, color_matrix
  self.color_table = myt

END
