FUNCTION ncfile::INIT, ncfile_name
   
   ; precompile access functions
   self->ncfile::get

   ; open file
   self.fid = NCDF_OPEN(ncfile_name,/NOWRITE)
   if (self.fid eq -1) then begin
       print,'ERROR OPENING FILE: ',ncfile_name
       return,0
   endif
   self.fname = ncfile_name

  ; inquire file content
  result = NCDF_INQUIRE(self.fid)
  self.ndims = result.ndims
  self.nvars = result.nvars
  self.ngatts= result.ngatts
  self.nrecs = result.recdim

  ; extract dimensions information
  self.dnames = ptr_new(strarr(self.ndims))
  self.dsizes = ptr_new(lonarr(self.ndims))
  for did = 0, self.ndims-1 do begin
      NCDF_DIMINQ, self.fid, did, name, size
      (*self.dnames)[did] = name
      (*self.dsizes)[did] = size
  endfor

  ; extract variable information
  self.vnames = ptr_new(strarr(self.nvars))
  self.vndims = ptr_new(lonarr(self.nvars))
  self.v2dims = ptr_new(ptrarr(self.nvars))
  self.vunits = ptr_new(strarr(self.nvars)) & (*self.vunits)[*] = '' ; variables units
  self.vnulls = ptr_new(fltarr(self.nvars)) & (*self.vnulls)[*] = !Values.D_NaN ; variables missing values
  for vid = 0, self.nvars-1 do begin
    result = NCDF_VARINQ(self.fid,vid)
    if (result.ndims gt 0) then begin
      (*self.vnames)[vid] = result.name
      (*self.vndims)[vid] = result.ndims
      if (result.ndims gt 0) then begin  ; variable is not constant
        (*self.v2dims)[vid] = ptr_new(lonarr(result.ndims))
        for idim=0,result.ndims-1 do begin
          (*(*self.v2dims)[vid])[idim] = result.dim[idim]
        endfor
        ; if variable is one-dimensional and has same name as its dimension
        ; then it stores the dimension values
        ;if (result.ndims eq 1) then begin
        ;    did = self->get_dimid_of_var(0,vid)
        ;    if ((*self.vnames)[vid] eq (*self.dnames)[did]) then $
        ;       (*self.d2var)[did] = vid
        ;endif
      endif
      ; attributes: units and missing value
      ; CGB - added _fillvalue
      for iatt=0,result.natts-1 do begin
          attname = NCDF_ATTNAME(self.fid,vid,iatt) ; attribute name
          if (strpos(strlowcase(attname),'units') ge 0) then begin
              NCDF_ATTGET,self.fid,vid,attname,value
              (*self.vunits)[vid] = string(value)
          endif else if (   strpos(strlowcase(attname),'missing_value') ge 0 $
                         or strpos(strlowcase(attname),'_fillvalue') ge 0 $
                         or strpos(strlowcase(attname),'null_value') ge 0) then begin
              NCDF_ATTGET,self.fid,vid,attname,value
              (*self.vnulls)[vid] = value
          endif
      endfor
    endif
  endfor

   return,1
END
