; methods to SET geov_gui private fields (i.e. update widget selection)

pro geov_gui::toggle_overplot
  if self.overplot then self.overplot=0B else self.overplot=1B
end

pro geov_gui::set_overplot, x
  self.overplot = byte(x)
end

PRO geov_gui::set_lat, indexes
    if (self.lats_wid gt 0) then begin
        ; check list range
        numelements = widget_info(self.lats_wid, /list_number)
        maxindex = max(indexes, min=minindex)
        if (minindex ge 0 and maxindex le numelements-1) then widget_control, self.lats_wid, set_list_select=indexes
    endif
END

PRO geov_gui::set_lon, indexes
    if (self.lons_wid gt 0) then begin
        ; check list range
        numelements = widget_info(self.lons_wid, /list_number)
        maxindex = max(indexes, min=minindex)
        if (minindex ge 0 and maxindex le numelements-1) then widget_control, self.lons_wid, set_list_select=indexes
    endif
END

PRO geov_gui::set_lev, indexes
    if (self.levs_wid gt 0) then begin
        ; check list range
        numelements = widget_info(self.levs_wid, /list_number)
        maxindex = max(indexes, min=minindex)
        if (minindex ge 0 and maxindex le numelements-1) then widget_control, self.levs_wid, set_list_select=indexes
    endif
END

PRO geov_gui::set_time, indexes
    if (self.times_wid gt 0) then begin
        ; check list range
        numelements = widget_info(self.times_wid, /list_number)
        maxindex = max(indexes, min=minindex)
        if (minindex ge 0 and maxindex le numelements-1) then widget_control, self.times_wid, set_list_select=indexes
    endif
END

PRO geov_gui::set_plot, ptype
    @geov_pars

    ; restore previous map?
    if (ptype eq MAP) then begin
        self.ptype = self.map
    endif else begin
        self.ptype = ptype
        if ((geov_get_bit_struct(ptype)).mapbit gt 0) then self.map = ptype
    endelse

    ; set plot title accordingly
    CASE self.ptype OF

         MAP_AT:    ptitle = MAP_AT_TITLE
         MAP_PA:    ptitle = MAP_PA_TITLE
         MAP_NP:    ptitle = MAP_NP_TITLE
         MAP_SP:    ptitle = MAP_SP_TITLE
         MAP_GP:    ptitle = MAP_GP_TITLE
         MAP_USER:  ptitle = MAP_USER_TITLE

         LATvsLON: ptitle = LATvsLON_TITLE
         LATvsLONpress: ptitle = LATvsLONpress_TITLE
         LEVvsLAT: ptitle = LEVvsLAT_TITLE
         LEVvsLON: ptitle = LEVvsLON_TITLE
         LATvsTIM: ptitle = LATvsTIM_TITLE
         LONvsTIM: ptitle = LONvsTIM_TITLE
         LEVvsTIM: ptitle = LEVvsTIM_TITLE

         LONaveLEVvsLAT: ptitle = LONaveLEVvsLAT_TITLE

         VARvsLAT: ptitle = VARvsLAT_TITLE
         VARvsLON: ptitle = VARvsLON_TITLE
         LEVvsVAR: ptitle = LEVvsVAR_TITLE
         VARvsTIM: ptitle = VARvsTIM_TITLE

         LONaveVARvsLAT: ptitle = LONaveVARvsLAT_TITLE
         LONaveLEVvsVAR: ptitle = LONaveLEVvsVAR_TITLE
         LONaveVARvsTIM: ptitle = LONaveVARvsTIM_TITLE
         LONaveLATvsTIM: ptitle = LONaveLATvsTIM_TITLE
         LONaveLEVvsTIM: ptitle = LONaveLEVvsTIM_TITLE

         LATLONaveLEVvsVAR: ptitle = LATLONaveLEVvsVAR_TITLE
         LATLONaveVARvsTIM: ptitle = LATLONaveVARvsTIM_TITLE
         LATLONaveLEVvsTIM: ptitle = LATLONaveLEVvsTIM_TITLE

         LATaveLEVvsVAR: ptitle = LATaveLEVvsVAR_TITLE
         LATaveVARvsTIM: ptitle = LATaveVARvsTIM_TITLE
         LATaveLEVvsTIM: ptitle = LATaveLEVvsTIM_TITLE

         ELSE: ptitle = '                                            '

    ENDCASE

    widget_control, self.ptitle_wid, set_value=string('PLOT: ',ptitle)
END

PRO geov_gui::set_scaling, value
    if (value eq 0 or value eq 1) then $
    widget_control, self.scaling_wid, set_value=value
END

PRO geov_gui::set_operator, op
    widget_control, self.operator_wid, set_droplist_select=op
END

PRO geov_gui::set_extractor_type, ex
    widget_control, self.extractor_wid, set_droplist_select=ex
END

PRO geov_gui::set_auto_contour, boolean
    if (boolean eq 0 or boolean eq 1) then $
    widget_control, self.auto_contour_wid, set_value=boolean
END

PRO geov_gui::set_auto_log_linear, val
    if (val eq 0 or val eq 2) then $
    widget_control, self.auto_log_linear_wid, set_value=val
END

PRO geov_gui::set_ipvar, ipvars
    widget_control, self.pvars_wid, set_list_select=ipvars
END

PRO geov_gui::set_ipvar, ipvars
    if (self.pvars_wid gt 0) then begin
        ; check list range
        numelements = widget_info(self.pvars_wid, /list_number)
        maxindex = max(ipvars,min=minindex)
        if (minindex ge 0 and maxindex le numelements-1) then $
            widget_control, self.pvars_wid, set_list_select=ipvars
    endif
END

; method to set or release edges associated with a given plotting
; variable
PRO geov_gui::set_edges, edges=edges, free=free

    ; retrieve current plotting variable
    ipv =  self->get_ipvar()

    ; release previous memory
    if (ptr_valid( (*self.edges)[ipv])) then ptr_free, (*self.edges)[ipv]

    if (keyword_set(edges)) then begin
       finites = finite(*edges) ; exclude +/- Inf
      ; allocate new memory
      (*self.edges)[ipv] = ptr_new((*edges)[where(finites eq 1)])
    endif

    plttr = self->get_plotter()
    

END

PRO geov_gui::set_levels_widget
    @geov_pars
    @nccoord_pars

    if ( self.logp_wid lt 1 ) then return

    widget_control, self.logp_wid, get_value = logpval

    ; store selected index
    ilev = self->get_lev()

    ; if a var is defined on the level interfaces we want
    ; to change the levels values displayed in the levels
    ; list widget
    ipvar = (self->get_ipvar())[0] ; take first selected var
    pvars = self.ncfiles->get_pvars() 
    vid = (*pvars)[ipvar]

    if (self.ncfiles->is_cflag_set(self.ncfiles->get_ilev(),NCCOORD_FLAG_PRESSURE)) then begin
        if (logpval eq 1) then begin
           if ( self.ncfiles->var_depends_on_ilevi(vid) ) then $
             levs = self.ncfiles->get_interface_levs2() $
           else $
             levs = self.ncfiles->get_levs2() 
        endif else begin
           if ( self.ncfiles->var_depends_on_ilevi(vid) ) then $
             levs = self.ncfiles->get_interface_levs() $
           else $
             levs = self.ncfiles->get_levs() 
        endelse
    endif else if (self.ncfiles->is_cflag_set(self.ncfiles->get_ilev(),NCCOORD_FLAG_KM) ) then begin
        if (logpval eq 0) then begin
           if ( self.ncfiles->var_depends_on_ilevi(vid) ) then $
             levs = self.ncfiles->get_interface_levs2() $
           else $
             levs = self.ncfiles->get_levs2() 
        endif else begin
           if ( self.ncfiles->var_depends_on_ilevi(vid) ) then $
             levs = self.ncfiles->get_interface_levs() $
           else $
             levs = self.ncfiles->get_levs() 
        endelse
    endif

    widget_control, self.levs_wid, set_value=strtrim(string(*levs,format=self->levs_format(levs)) ,2 )

    ; select same index
    self->set_lev, ilev

END

PRO geov_gui::set_const_press, press
  self.const_press = press
END

PRO geov_gui::set_totcol_flag, flag
  self.totcol_flag = flag
END
PRO geov_gui::set_tmass_flag, flag
  self.tmass_flag = flag
END

PRO geov_gui::set_numden_flag, flag
  self.numden_flag = flag
END

PRO geov_gui::set_summed_flds, flds
  self.summed_flds = flds
END

PRO geov_gui::set_sum_coefs, coefs
  self.sum_coefs = coefs
END

PRO geov_gui::set_dataname, name
  self.dataname = name
END

PRO geov_gui::set
END
