; method to instantiate a new gui object
FUNCTION geov_manager::create_gui, ncfilenames


    ; look for an empty slot in the guis array
    for ig=0, n_elements(self.guis)-1 do begin
      ; check object is not already instantiated
      if (not obj_valid(self.guis[ig])) then begin

          ; instantiate gui
          nguis = self->get_number_of_guis() + 1
          gui = obj_new('geov_gui', self, ncfilenames,xoffset=20*nguis,yoffset=20*nguis)
          ; register gui with itself and set as current
          ig1 = self->register_gui(gui)
          self->set_gui, gui
          ; register gui with all valid plotters
          for ip=0, n_elements(self.plotters)-1 do begin
            plotter = self.plotters[ip]
            if (obj_valid(plotter)) then begin
              ; register new gui with this plotter
              ig2 = plotter->register_gui(gui)
              ; register this plotter with new gui
              ;ip = gui->register_plotter(plotter)
            endif
          endfor ; loop over plotters
          return, gui
      endif
    endfor

    result = dialog_message('TOO MANY WINDOWS OPENED ALREADY!')

    return, obj_new() ; error

END
