; IDL object representing a netCDF file with coordinates lat, lon, lev and time
PRO geov_ncfile__define
    @geov_pars
    struct = { geov_ncfile,              $ ; class name
               inherits nccoordfile,   $ ; superclass
               ilat:0L,                $ ; latitude coordinate index
               ilon:0L,                $ ; longitude coordinate index
               ilev:0L,                $ ; altitude coordinate index
               ilevi:0L,               $ ; interface altitude coordinate index
               itim:0L,                $ ; time coordinate index
;mgs++ (22 April 2002)
               iuvar:0L,               $ ; wind vector U
               ivvar:0L,               $ ; wind vector V
;mgs--
               ; utility arrays
               pvbits:ptr_new(),            $ ; array containig true/false bits for each coordinate variable dependence
               p2coords:intarr(MAXCOORDS),  $ ; [MYLAT,MYLON,MYLEV,MYTIM] -->[ilat,ilon,ilev,itim](or -1 if unavailable)

               ; model-customed fields
               type:'',                $ ; model name (used for customization)
               levs2:ptr_new(),        $ ; levels expressed in pressure or log-pressure
               interface_levs2:ptr_new(),$ ; levels expressed in pressure or log-pressure at interface levs
               levunits:'',            $ ; level units attribute
;               timestamps:ptr_new()    $ ; model-customized time stamps
               times:obj_new()    $ ;
    }
END
