;; mgs 20 Apr 2002: added mlev as vertical coordinate name (ECHAM)
;; mgs 29 Aug 2002: added nlev as another vertical coordinate name (NCGRDX)
PRO geov_ncfile::find_coord
  @nccoord_pars
  @geov_pars

                                ; determine model type
                                ; loop over global attributes 
  for igatt=0, self.ngatts-1 do begin
      attname = ncdf_attname(self.fid, /global, igatt)
      ncdf_attget, self.fid, /global, attname, attvalue
      if (strlowcase(attname) eq 'title' or strlowcase(attname) eq 'base model') then begin
          attvalue=string(attvalue) ; must convert to string
          if (strpos(strlowcase(attvalue),'mozart') ge 0) then self.type = 'mozart'
          if (strpos(strlowcase(attvalue),'hank') ge 0) then self.type = 'hank'
      endif
                                ; temporary
      if (strlowcase(attname) eq 'conventions') then begin
          attvalue=string(attvalue) ; must convert to string
          if (strpos(strlowcase(attvalue),'ncar-csm') ge 0) then self.type = 'mozart'
      endif
  endfor

                                ; loop on variables to identify coordinates
                                ; coordinates variables are identified by name (no order is required)
  self.ncoords = 0              ; number of coordinates
  self.ilat=-1
  self.ilon=-1
  self.ilev=-1
  self.ilevi=-1
  self.itim=-1
  self.p2coords[*]=-1           ; coordinate not available

  self.cdims = ptr_new(lonarr(self.ndims))
  (*self.cdims)[*] = -1

;;  for vid=0, self.nvars-1 do begin
  for did=0, self.ndims-1 do begin

;    if ( (*self.vndims)[vid] eq 1) then begin ; check variable has only 1 dimension

;      did = self->get_dimid_of_var(0,vid)
;      lname = strlowcase((*self.vnames)[vid])
      lname = strlowcase((*self.dnames)[did])
      vid =  NCDF_VARID(self.fid, (*self.dnames)[did])

;      if vid ge 0 then begin

          if vid ge 0 then lunits = strlowcase((*self.vunits)[vid]) else lunits=''

          ; match variable name
          ;if (lname eq "slat" or lname eq "latitude" or lname eq "latitudes" $ ; for staggered latitude
          if (lname eq "lat" or lname eq "latitude" or lname eq "latitudes" $
              or lname eq "y" or lname eq "xlat" or lname eq "south_north" ) then begin
              (*self.cvars)[self.ncoords] = vid
              if (self.ilat ge 0) then void=dialog_message( 'More than one dimension found for latitude coordinate')
              self.ilat = self.ncoords
              self.p2coords[MYLAT] = self.ilat
              self.ncoords = self.ncoords + 1
              (*self.cdims)[self.ilat] = did

          endif else if (lname eq "lon" or lname eq "longitude" $
          ;endif else if (lname eq "slon" or lname eq "longitude" $ ; for staggered longitude
                         or lname eq "longitudes" or lname eq "x" or lname eq "xlong" or lname eq "west_east" ) then begin
              (*self.cvars)[self.ncoords] = vid
              if (self.ilon ge 0) then void=dialog_message( 'More than one dimension found for longitude coordinate')
              self.ilon = self.ncoords
              self.p2coords[MYLON] = self.ilon
              self.ncoords = self.ncoords + 1
              (*self.cdims)[self.ilon] = did

          endif else if (lname eq "ilev" or lname eq "ilevel" or lname eq "ilevels" ) then begin ; interface levels
              (*self.cvars)[self.ncoords] = vid
              if (self.ilevi ge 0) then    void=dialog_message( 'More than one dimension found for vertical interface coordinate')
              self.ilevi = self.ncoords
              self.p2coords[MYLEVI] = self.ilevi
              self.ncoords = self.ncoords + 1
              (*self.cdims)[self.ilevi] = did

          endif else if (lname eq "lev" or lname eq "level" or lname eq "levels" $
                         or lname eq "z" or lname eq "nz" or lname eq "levsoi" $
                         or lname eq "pressure" OR lname EQ "mlev" $
                         or lname eq "alt" OR lname EQ "altitude" $
                         OR lname EQ "nlev" OR lname EQ "p" or lname eq "bottom_top" ) then begin
              (*self.cvars)[self.ncoords] = vid
              if (self.ilev ge 0) then begin
                  void=dialog_message( 'More than one dimension found for vertical coordinate')
              endif
              self.ilev = self.ncoords
              self.p2coords[MYLEV] = self.ilev
                                ; levels special flags
              if (strpos(lname,'pressure') ge 0 or $
                  strpos(lunits,'pressure') ge 0 or strpos(lunits,'pa') ge 0 $
                  or strpos(lunits,'mb') ge 0 or strpos(lunits,'millibar') ge 0) then $
                (*self.cflags)[self.ncoords] = (*self.cflags)[self.ncoords] or NCCOORD_FLAG_PRESSURE
              if (strpos(lunits,'km') ge 0 or strpos(lunits,'kilometer') ge 0) then $
                (*self.cflags)[self.ncoords] = (*self.cflags)[self.ncoords] or NCCOORD_FLAG_KM

              if strpos(lunits,'level') ge 0 or strpos(lunits,'index') ge 0 THEN $
                (*self.cflags)[self.ncoords] = (*self.cflags)[self.ncoords] or NCCOORD_FLAG_INDEX
              self.ncoords = self.ncoords + 1
              self.levunits = lunits
              ;; MOZART special:
              IF lunits EQ 'hybrid_sigma_pressure' THEN lunits = 'hPa'
              
              (*self.cdims)[self.ilev] = did

          endif else if (   (self.type eq 'hank' and lname eq "mtime") $
                            or (self.type ne 'hank' and (lname eq "time" or lname eq "times" or lname eq "month")) ) then begin
              (*self.cvars)[self.ncoords] = vid
              if (self.itim ge 0) then void=dialog_message( 'More than one dimension found for time coordinate')
              self.itim = self.ncoords
              self.p2coords[MYTIM] = self.itim
              (*self.d2coord)[did] = self.itim
              self.ncoords = self.ncoords + 1
              (*self.cdims)[self.itim] = did
          endif 
 ;     endif
                                ;   endif  ; only 1 dimension
  endfor                        ; loop over variables

END
