
Function geov_plotter::get_time_tickvals

  ts_ptr = ((self->get_gui())->get_ncfiles())->get_times()
  ts = *ts_ptr

  ; get only the times that will be ploted
  times = ts[ where((ts ge self.xrange[0])and(ts le self.xrange[1])) ]

  ntks = 3 ; ideal number of tick marks
  ntimes = n_elements(times)

  if ( ntimes gt ntks ) then begin
    spacing = fix(ntimes/ntks)
    index = 0
    tickvals = times[index]
    while (index le (ntimes-1)) do begin
      index = index + spacing
      if (index lt ntimes) then tickvals = [tickvals, times[index]]
    endwhile
  endif else tickvals = times

  return, tickvals
End



; It is assumed that the time values are in seconds
Function get_secs_str, value
  secs = value*3600.*24.
  return, String(secs,FORMAT = '(i8)' )
end

Function get_hour_str, value
  hours = value*24.
  return, String(hours,FORMAT = '(f8.2)' )
end

Function get_days_str, value
  days = value
  return, String(days,FORMAT = '(f12.2)' )
end

; utility function to format relative-time tick labels
; NOTE: this function cannot be an object method...
FUNCTION geov_plotter_get_relativetime, iaxis, itick, value
  common geov_plotter_timestamp_common, ncfiles, timescale, starttime
  @geov_pars

  case timescale of
    TIME_SCALE_NONE: return, ncfiles->get_timestamp(value-starttime)
    TIME_SCALE_SECS: return, get_secs_str(value-starttime)
    TIME_SCALE_HOUR: return, get_hour_str(value-starttime)
    TIME_SCALE_DAYS: return, get_days_str(value-starttime)
  endcase

  ; return the default
  return, ncfiles->get_timestamp(value)
END

; utility function to format time stamps 
; NOTE: this function cannot be an object method...
FUNCTION geov_plotter_get_timestamp, iaxis, itick, value
  common geov_plotter_timestamp_common, ncfiles, timescale, starttime

  ; we subtracted the starttime out earlier and need to add it back here
;;??  value = value+starttime

  return, ncfiles->get_timestamp(value)
END


FUNCTION geov_plotter::get_ptype
    return, self.ptype
END

FUNCTION geov_plotter::get_draw_wid
  return, self.draw_wid
END

FUNCTION geov_plotter::get_xcoord_index
  return, self.icx
END

FUNCTION geov_plotter::get_ycoord_index
  return, self.icy
END

FUNCTION geov_plotter::get_xs
  return, self.xs
END

FUNCTION geov_plotter::get_ys
  return, self.ys
END

FUNCTION geov_plotter::get_extractors
  return, self.extractors
END

FUNCTION geov_plotter::get_zoomer
  return, self.zoomer
END

; method to return current extractor or extractor matching a given gui
FUNCTION geov_plotter::get_extractor, gui=gui, index=index, other=other

  ; return extractor associated with specified gui
  if (keyword_set(gui)) then begin
      for ig=0, n_elements(self.guis)-1 do begin
          if (obj_valid(self.guis[ig])) then begin
              if ((self.guis[ig] eq gui) eq 1) then return, self.extractors[ig]
          endif
      endfor

  ; return extractor at a specified index
  endif else if (keyword_set(index)) then begin
     if (obj_valid(self.extractors[index])) then return, self.extractors[index]

  ; return non-current extractor
  endif else if (keyword_set(other)) then begin
     if (self.igui eq 0) then iother=1 else iother=0
     return, self.extractors[iother]

  ; return current extractor
  endif else begin
     return, self.extractors[self.igui]

  endelse

  ; error
  return, obj_new()

END

; mgs: added option keyword to set type of contour level definition
FUNCTION geov_plotter::get_edges, coption=coption, usr_dfnd_lvls=usr_dfnd_lvls, usr_scl_fctr=usr_scl_fctr
  usr_dfnd_lvls=self.usr_dfnd_lvls
  usr_scl_fctr=self.usr_scl_fctr
  coption = self.coption
  return, self.edges
END

FUNCTION geov_plotter::get_operator
  return, self.operator
END

FUNCTION geov_plotter::get_extractor_type
  return, self.extractor_type
END

FUNCTION geov_plotter::get_xyzrange,ixyz
    CASE ixyz OF
         0: return, self.xrange
         1: return, self.yrange
         2: return, self.zrange
    ELSE: print,'ERROR in geov_plotter::get_xyzrange ',ixyz
    ENDCASE
    return,[0,0]
END

FUNCTION geov_plotter::get_auto_contour
    return, self.auto_contour
END

FUNCTION geov_plotter::get_color_manager
  return, self.color_manager
END

FUNCTION geov_plotter::get_drawcolors
  return, self.drawcolors[1:*]
END

FUNCTION geov_plotter::get_scaling
  return, self.scaling
END

FUNCTION geov_plotter::get_title
  return, self.title
END

FUNCTION geov_plotter::get_xtitle
  return, self.xtitle
END

FUNCTION geov_plotter::get_ytitle
  return, self.ytitle
END

FUNCTION geov_plotter::get_filename_info
  return, self.filename_info
END

FUNCTION geov_plotter::get_datetime_info
  return, self.datetime_info
END

FUNCTION geov_plotter::get_window_size
  return, self.window_size
END

FUNCTION geov_plotter::get_data
  return, self.data
END

FUNCTION geov_plotter::get_displayeddata, xs=xs, ys=ys

  xs = self.xs
  ys = self.ys

  return, self.displayeddata
END

PRO geov_plotter::get
END
