
PRO geov_plotter::import_all

    ; from current gui
    self->import_ptype
    self->import_operator
    self->import_auto_contour
    if (self->get_auto_contour() eq 0) then self->import_edges
    self->import_scaling


    ; from gui to extractor
    for ix=0,n_elements(self.guis)-1 do begin
      if (obj_valid(self.extractors[ix])) then begin
          ; specify which index to import to in case of double selection
          if (ix eq self.igui) then fromindex=0 else fromindex=1
          ; import user selection
          (self.extractors[ix])->import_all, fromindex
      endif
    endfor

END

PRO geov_plotter::import_ptype
    ptype = (self->get_gui())->get_ptype()
    self->set_ptype, ptype
END

PRO geov_plotter::import_operator
    @geov_pars

    op = (self->get_gui())->get_operator()
    ex = (self->get_gui())->get_extractor_type()

;    if ( ex eq EX_SIMPLE ) then begin
      (self.extractors[self.igui])->set_col_dens, 0
      (self.extractors[self.igui])->set_num_dens, 0
      (self.extractors[self.igui])->set_tmass_flag, 0
;    endif

    if ( (ex eq EX_TOTAL_COL) or (ex eq EX_COL_ABOVE) or (ex eq EX_TROP_COL) or (ex eq EX_ABOVETROP_COL) ) then begin
      self.extractors[self.igui]->set_col_dens, ex
      (self.extractors[self.igui])->set_num_dens, 0
      (self.extractors[self.igui])->set_tmass_flag, 0
    endif

    if ( ex eq EX_NUM_DENS ) then begin
      self.extractors[self.igui]->set_num_dens, 1
      (self.extractors[self.igui])->set_col_dens, 0
      (self.extractors[self.igui])->set_tmass_flag, 0
    endif

    if ( ex eq EX_TOT_MASS ) then begin
      self.extractors[self.igui]->set_num_dens, 0
      (self.extractors[self.igui])->set_col_dens, 0
      (self.extractors[self.igui])->set_tmass_flag, 1
    endif


    self->set_operator, op
    self->set_extractor_type, ex
END

PRO geov_plotter::import_auto_contour
    boolean = (self->get_gui())->get_auto_contour()
    self->set_auto_contour, boolean
    auto_log_linear_val = 0
    if ( boolean ) then auto_log_linear_val = (self->get_gui())->get_auto_log_linear()
    self->set_auto_log_linear, auto_log_linear_val
END

PRO geov_plotter::import_scaling
    boolean = (self->get_gui())->get_scaling()
    self->set_scaling, boolean
END

PRO geov_plotter::import_edges
    ipvar = (self->get_extractor())->get_ipvar()
    edges = (self->get_gui())->get_edges(ipvar)
    if (ptr_valid(edges)) then self->set_edges, edges
END

PRO geov_plotter::import_anim_pars
    self.astep = ((self->get_gui())->get_anim_pars()).step
    self.astart = ((self->get_gui())->get_anim_pars()).start
END

; method to REDEFINE map settings for zoom=0  from current GUI selection
PRO geov_plotter::import_map
    @geov_pars
    @map_pars
    @nccoord_pars


    ; import map type
    self->import_ptype

    ; map projection
    if (self.ptype eq MAP_PA or self.ptype eq MAP_AT) then $
         self.map_projection = MAP_CYLINDRICAL $
    else self.map_projection = MAP_ORTHOGRAPHIC

    ; map flags
    if (self.ptype eq MAP_PA or self.ptype eq MAP_AT) then begin
        self->set_map_flag, MAP_FLAG_ISOTROPIC, 0
        self->set_map_flag, MAP_FLAG_BORDER, 1
    endif else begin
        self->set_map_flag, MAP_FLAG_ISOTROPIC, 1
        self->set_map_flag, MAP_FLAG_BORDER, 0
    endelse

    ; determine map system
    gui = self->get_gui()
    ncfiles = gui->get_ncfiles()
    if (ncfiles->is_cflag_set(ncfiles->get_ilon(),NCCOORD_FLAG_NEGLON)) then $
         map_system = MAP_SYSTEM_NEGATIVE $
    else map_system = MAP_SYSTEM_POSITIVE

    if (self.ptype eq MAP_GP) then begin
        ; pass the latitude, longitude selection from gui
        ilats = gui->get_lat()
        ilons = gui->get_lon()
        latcen = (*(ncfiles->get_lats()))[ilats[0]] ; choose first index in case of multiple selection
        loncen = (*(ncfiles->get_lons()))[ilons[0]] ; choose first index in case of multiple selection
        self.zoomer->setup_map, map_type=self.ptype, map_system=map_system, map_center=[latcen, loncen]

        self.map_latlab = loncen
        self.map_lonlab = latcen

        ; don't let the longitude labels get close to the poles
        ;self.map_lonlab = min([self.map_lonlab , 50] )
        ;self.map_lonlab = max([self.map_lonlab , -50] )
        if ( latcen ge 0 ) then self.map_lonlab=-90  ; hide the longitude labels
        if ( latcen lt 0 ) then self.map_lonlab= 90

    endif else begin
        self.zoomer->setup_map, map_type=self.ptype, map_system=map_system

        self.map_latlab = 0
        self.map_lonlab = 0
        ;if (self.ptype eq MAP_NP) then self.map_lonlab = 50
        ;if (self.ptype eq MAP_SP) then self.map_lonlab = -50
        if (self.ptype eq MAP_NP) then self.map_lonlab = -90 ; hide the longitude labels
        if (self.ptype eq MAP_SP) then self.map_lonlab =  90
    endelse


END

PRO geov_plotter::import
END
