pro geov_plotter::interpolate_data, data1, data2, xs, ys, oxs, oys

  if ptr_valid(oxs) then old_xs = float(*oxs)
  if ptr_valid(oys) then old_ys = float(*oys)
  if ptr_valid(xs)  then new_xs = float(*xs)
  if ptr_valid(ys)  then new_ys = float(*ys)

  dat = *data2
;  ptr_free, data2

  if ((geov_get_bit_struct(self.ptype)).mapbit gt 0) then ismap=1 else ismap=0 ; map flag
  if ( ismap  ) then if ( grid_goes_around(self.xs,360.) eq 2 ) then begin
    dat = [ dat, dat[0,*] ]
    old_xs = [old_xs, old_xs[0]+360.]
  endif

;  data2 = ptr_new(operator_interp( dat, old_xs=old_xs,old_ys=old_ys,new_xs=new_xs,new_ys=new_ys ))
  *data2 =         operator_interp( dat, old_xs=old_xs,old_ys=old_ys,new_xs=new_xs,new_ys=new_ys )

  if ptr_valid(self.oxs) then begin
    indices = where( new_xs ge min(old_xs) and new_xs le max(old_xs) )
    *data1 = (*data1)[indices,*]
    *xs = (*xs)[indices]
    *oxs = *xs
    if ptr_valid(oys) then begin
        indices = where( new_ys ge min(old_ys) and new_ys le max(old_ys) )
        *data1 = (*data1)[*,indices]
        *ys = (*ys)[indices]
        *oys = *ys
    endif
  endif else if ptr_valid(oys) then begin
    indices = where( new_ys ge min(old_ys) and new_ys le max(old_ys) )
    *data1 = (*data1)[indices]
    *ys = (*ys)[indices]
    *oys = *ys
  endif

end

FUNCTION geov_plotter::operate_data
    @geov_pars

    ; free up memory
    if (ptr_valid(self.xs)) then ptr_free, self.xs
    if (ptr_valid(self.ys)) then ptr_free, self.ys
    if (ptr_valid(self.oxs)) then ptr_free, self.oxs
    if (ptr_valid(self.oys)) then ptr_free, self.oys
    if (ptr_valid(self.data)) then ptr_free, self.data
    if (ptr_valid(self.odata)) then ptr_free, self.odata
    if (ptr_valid(self.uwind)) then ptr_free, self.uwind

    ; use xs and ys from current extractor
    if (ptr_valid( (self.extractors[self.igui])->get_xs() ) ) then $
        self.xs = ptr_new(*((self.extractors[self.igui])->get_xs()))
    if (ptr_valid( (self.extractors[self.igui])->get_ys() ) ) then $
        self.ys = ptr_new(*((self.extractors[self.igui])->get_ys()))

    ; retrieve data from current extractor
    data_0 = (self.extractors[self.igui])->get_data()

    ; if binary operator, check data sets are compatible
    if (self->is_binary(self.operator) eq 1) then begin

        ; check both extractors are valid
        if ( (not obj_valid(self.extractors[0])) or (not obj_valid(self.extractors[1])) ) then begin
           message,'ERROR: CURRENT PLOTTER SUPPORTS ONLY ONE VARIABLE FIELD'
           return, 1
       endif

        ; retrieve second dataset
        if (self.igui eq 0) then iother=1 else iother=0 ; index of other gui
        data_1 = (self.extractors[iother])->get_data()

       ; get xs and ys from other extractor
       if (ptr_valid( (self.extractors[iother])->get_xs() ) ) then $
           self.oxs = ptr_new(*((self.extractors[iother])->get_xs()))
       if (ptr_valid( (self.extractors[iother])->get_ys() ) ) then $
           self.oys = ptr_new(*((self.extractors[iother])->get_ys()))
       ; interpolate the data ?
       interp = 0B

       if (ptr_valid( self.xs ) and ptr_valid(self.oxs)) then $
          if not array_equal( *self.xs, *self.oxs ) then interp = 1B
       if (ptr_valid( self.ys ) and ptr_valid(self.oys)) then $
          if not array_equal( *self.ys, *self.oys ) then interp = 1B

       if ( interp ) then begin

          self->interpolate_data, data_0, data_1, self.xs, self.ys, self.oxs, self.oys

 
       endif

    endif ; data sets are compatible

    ;; VMR or MMR special case: optionally, scale data by 1E+6, 1E+9, 1E+12, ...
    if ( (self.scaling GT 0) and (self.extractor_type ne EX_TOTAL_COL) and (self.extractor_type ne EX_TOT_MASS) and $
         (self.extractor_type ne EX_COL_ABOVE) and (self.extractor_type ne EX_NUM_DENS)) then begin

        ; scale current dataset by best scale factor
        vunits_0 = strlowcase( (self.extractors[self.igui])->get_vunits() )
        vname_0 = (self.extractors[self.igui])->get_vname()
        if (vunits_0 eq 'vmr' or vunits_0 eq 'mmr' OR vunits_0 EQ 'mole/mole') then begin
            self.scale_factor = self->scale_data(data_0, scale_factor=self.scale_factor)
        endif

        ; scale other dataset
        if (self->is_binary(self.operator) eq 1) then begin
            vunits_1 = strlowcase( (self.extractors[iother])->get_vunits() )
            vname_1 = (self.extractors[iother])->get_vname()
            if (vunits_1 eq 'vmr' or vunits_1 eq 'mmr' OR vunits_0 EQ 'mole/mole') then begin
                ; if same variable (identified by name), use same scale factor
                if (vname_0 eq vname_1) then begin
                    scale_factor = self->scale_data(data_1, scale_factor=self.scale_factor)
                ; otherwise determine best scale factor for this dataset
                endif else begin
                    scale_factor = self->scale_data(data_1, /automatic)
                endelse
            endif
        endif

    endif

    ; perform mathematical operations on datasets
    CASE self.operator OF

         OP_NONE:  begin
                    self.data = ptr_new(*data_0)
                   end
         OP_SMOOTH: BEGIN
                     ; retrieve plot type
                     xtype = self.ptype mod 10  ; coordinate mask on X axis
                     if (xtype eq TIMBIT) then begin
                       gui = self.guis[self.igui]
                       width=self.smooth_width
                       self.data = operator_smooth(data_0, group_leader=gui->get_base(), width=width )
                       self.smooth_width=width
                     endif else begin
                       xx=dialog_message( 'Smoothing operator is only for time plots.',information=1)
                       self.data = ptr_new(*data_0)
                     endelse
                    END

         OP_INVERSE: self.data = operator_inverse(data_0)

         OP_SUM: self.data = operator_sum(data_0, data_1)

         OP_DIFFERENCE: self.data = operator_difference(data_0, data_1)

         OP_DIFFERENCE_PERCENT: self.data = operator_difference_percent(data_0, data_1)

         OP_RATIO: self.data = operator_ratio(data_0, data_1)

         OP_USR_DEF: begin
                       labels = self.manager->get_operand_labels()
                       dataptrarr = self.manager->get_operand_data(xs_ptrs=xs_ptrs, ys_ptrs=ys_ptrs)
                       dptr = operator_userdef( dataptrarr, labels , expression=self.usr_expression, $ 
                                                group_leader=self.guis[self.igui]->get_base(), $
                                                xs_ptrs=xs_ptrs, ys_ptrs=ys_ptrs , plotter=self, /interpolate)
                       if ( ptr_valid(dptr) ) then self.data = dptr $
                       else if ( ptr_valid(self.displayeddata) ) then self.data = ptr_new(*(self.displayeddata))  $
                       else self.data = ptr_new(*data_0)

                     end

         ELSE: message,'ERROR: UNRECOGNIZED OPERATOR'

    ENDCASE

    ; check for errors in operations
    if (not ptr_valid(self.data)) then begin
        message,'ERROR IN COMBININIG DATA'
        return, 1
    endif

;mgs++
    ; get wind vector data if available (always from active GUI)
    uwind = (self.extractors[self.igui])->get_uwind()
    IF ptr_valid(uwind) THEN self.uwind = ptr_new(*uwind)
    vwind = (self.extractors[self.igui])->get_vwind()
    IF ptr_valid(vwind) THEN self.vwind = ptr_new(*vwind)
;mgs--

    ; 1D plot special case
    if (self.icx lt 0) then self.xs = self.data ; data on X axis
    if (self.icy lt 0) then self.ys = self.data ; data on Y axis

    if (ptr_valid(self.displayeddata)) then ptr_free, self.displayeddata
    self.displayeddata = ptr_new( *self.data )

    gui = self.guis[self.igui]
    if gui->get_overplot() then begin
      self.odata = self.manager->get_oplot_data(self)
      coords = self.manager->get_oplot_coords(self)
      self.oxs = coords[0]
      self.oys = coords[1]
      if ptr_valid(self.odata) then gui->set_overplot,1B else gui->set_overplot,1B
    endif
 
    return, 0 ; no error

END
