; method to scale a given dataset by given scale factor or by 'best' scale factor
FUNCTION geov_plotter::scale_data, data, scale_factor=scale_factor, automatic=automatic

   ; check for missing values
   good_indexes = where(finite(*data) eq 1 , ngood)

   ; scale only good values
   if (ngood gt 0) then begin

       ; use given scale factor
      if (n_elements(scale_factor) GT 0) then begin
         ;; constant scale factor
         IF scale_factor GT 0. THEN BEGIN 
            (*data)[good_indexes] = scale_factor*(*data)[good_indexes]
         ENDIF ELSE BEGIN
            ;; vmr -> molec/cm^3
         ENDELSE 
      ENDIF 

      ;; determine best scale factor for this dataset and return it
      IF keyword_set(automatic) THEN BEGIN
         lgmax = alog10(max((*data)[good_indexes]))
         factor=abs(lgmax)/3.
         if (factor le 1.) then scale_factor = 1.   $
         else if (factor le 2.) then scale_factor = 1.E6 $
         else if (factor le 3.) then scale_factor = 1.E9 $
         else                        scale_factor = 1.E12
         (*data)[good_indexes] = scale_factor*(*data)[good_indexes]
      ENDIF 

   endif

   return, scale_factor

END
