; method to restrict the range of each coordinate
; to the overlap of the two files
PRO geov_plotter::update_crange
 @geov_pars

 ; loop over extractors
 first=1
 for ix=0, n_elements(self.extractors)-1 do begin
  if (obj_valid(self.extractors[ix])) then begin

    ncfiles = (self.extractors[ix])->get_ncfiles()
    p2coords=((self.extractors[ix])->get_ncfiles())->get_p2coords()

    ; loop over coordinates for that file
    for ic=0, MAXCOORDS-1 do begin
        icf = p2coords[ic] ; coordinate index in file
        values = ncfiles->get_coord(icf)
        minvalue = min(*values,max=maxvalue)

        ; get full range from first valid extractor
        if (first eq 1) then begin
            self.cminima[ic,0] = minvalue
            self.cmaxima[ic,0] = maxvalue
        ; restrict range for all others
        endif else begin
            if (self.cminima[ic,0] lt minvalue) then self.cminima[ic,0] = minvalue
            if (self.cmaxima[ic,0] gt maxvalue) then self.cmaxima[ic,0] = maxvalue
        endelse

    endfor ; loop over coordinates

    if (first eq 1) then first = 0
  endif ; extractor is valid
 endfor ; loop over extractors

END
