; utility class to provide zooming functionality to geov_plotter
PRO geov_zoomer__define
@geov_pars.pro

    MAX_ZOOMS = 10  ; maximum number of zooming steps

    struct = { geov_zoomer,        $ ; class name
               plotter: obj_new(), $ ; reference to master geov_plotter

               ; PUBLIC FIELDS
               ; arrays ordered as lat, lon, lev, time
               izoom:0B,                      $ ; zooming step counter
               ; cminima, cmaxima are in data coordinate system
               cminima:dblarr(MAXCOORDS,MAX_ZOOMS),   $ ; array of zooming minima for each coordinate
               cmaxima:dblarr(MAXCOORDS,MAX_ZOOMS),   $ ; array of zooming maxima for each coordinate
               ; map_centers, map_limits are in map coordinate system
               map_limits:dblarr(4,MAX_ZOOMS),$ ; array of map limits
               map_center:dblarr(2,MAX_ZOOMS),$ ; array of map centers

               ; PRIVATE FIELDS (all in pixels=device coordinate)
               ismap:0B,                    $ ; map flag
               mode:0B,                     $ ; MODE_BOX or MODE_CIRCLE
               mouse_status:0,              $ ; keep track of last mouse event
               xPress:0L,yPress:0L,         $ ; device coordinate where mouse was pressed
               box_xs:dblarr(5),            $ ; x-edges of moving box
               box_ys:dblarr(5),            $ ; y-eddges of movin box
               circle:dblarr(2,100),        $ ; 2xN array of circle points
               center:dblarr(2),            $ ; circle center
               is_showing:0B,               $ ; indicates if selection box or circle is showing
               gf:0,                        $ ; graphic function          
               color:0B,                    $ ; color for drawing

               ; static fields
               MODE_BOX:0B,                 $ ; use box for zooming
               MODE_CIRCLE:1B               $ ; use circle for zooming

    }

END
