PRO hank_converter::build_gui, mbar=mbar

  ; read data directories from user preferences
  preferences = obj_new('geov_preferences')

  tmp = widget_label(self.base_wid, $
                     value='Choose netCDF file to convert from directory:', $
                     /align_center)

  data_dirs = preferences->get_data_dirs()
  self.data_dirs_wids = ptr_new(lonarr(n_elements(*data_dirs)))
  for i=0, n_elements(*data_dirs)-1 do begin
      (*self.data_dirs_wids)[i] = widget_button(self.base_wid, $
                                                /align_center, $
                                                resource_name='my_button', $ 
                                                value=(*data_dirs)[i], uvalue=self)
  endfor

  self.file_in_wid = cw_field(self.base_wid,title='INPUT FILE:',xsize=50)
  self.file_out_wid= cw_field(self.base_wid,title='OUTPUT FILE:',xsize=50)

  frame_wid = widget_base(self.base_wid, /frame, row=2)
  self.lat_wids[0] = cw_field(frame_wid, title='Lat min:', /floating, uvalue=self, xsize=10, value=10)
  self.lat_wids[1] = cw_field(frame_wid, title='Lat max:', /floating, uvalue=self, xsize=10, value=30)
  self.lat_wids[2] = cw_field(frame_wid, title='Lat delta:', /floating, uvalue=self, xsize=10, value=2)
  self.lon_wids[0] = cw_field(frame_wid, title='Lon min:', /floating, uvalue=self, xsize=10, value=-120)
  self.lon_wids[1] = cw_field(frame_wid, title='Lon max:', /floating, uvalue=self, xsize=10, value=-80)
  self.lon_wids[2] = cw_field(frame_wid, title='Lon delta:', /floating, uvalue=self, xsize=10, value=2)

  self.actions_wid = cw_bgroup(self.base_wid, /row, uvalue=self, ['CONVERT', 'QUIT'] )

  obj_destroy, preferences

END

